import { ApsaraVideoPlayer } from './ApsaraVideoPlayer';
import { ApsaraVideoListPlayer } from './ApsaraVideoListPlayer';
import { PrivateService } from '../private_service/PrivateService';
import { ApsaraLiveShiftPlayer } from './ApsaraLiveShiftPlayer';
export class AliPlayerFactory {
    static createAliPlayer(b8, c8) {
        PrivateService.preInitService(b8);
        if (c8) {
            return new ApsaraVideoPlayer(b8, c8);
        }
        else {
            return new ApsaraVideoPlayer(b8, "");
        }
    }
    static createAliListPlayer(z7, a8) {
        PrivateService.preInitService(z7);
        if (a8) {
            return new ApsaraVideoListPlayer(z7, a8);
        }
        else {
            return new ApsaraVideoListPlayer(z7, "");
        }
    }
    static createAliLiveShiftPlayer(x7, y7) {
        PrivateService.preInitService(x7);
        if (y7) {
            return new ApsaraLiveShiftPlayer(x7, y7);
        }
        else {
            return new ApsaraLiveShiftPlayer(x7, "");
        }
    }
}
