import premierlibrary from 'libpremierlibrary.so';
export class AliPlayerGlobalSettings {
    static getInstance() {
        if (AliPlayerGlobalSettings.sInstance == undefined) {
            AliPlayerGlobalSettings.sInstance = new AliPlayerGlobalSettings();
        }
        return AliPlayerGlobalSettings.sInstance;
    }
    constructor() {
        this.nOnGetUrlHashCallback = (m9) => {
            if (AliPlayerGlobalSettings.sOnGetUrlHashCallback != null) {
                return AliPlayerGlobalSettings.sOnGetUrlHashCallback.getUrlHashCallback(m9);
            }
            else {
                return null;
            }
        };
    }
    static OnGetUrlHashCallback(j9) {
        if (AliPlayerGlobalSettings.sOnGetUrlHashCallback != null) {
            let k9 = AliPlayerGlobalSettings.sOnGetUrlHashCallback.getUrlHashCallback(j9);
            if (k9 != undefined) {
                if (k9.length == 0) {
                    return AliPlayerGlobalSettings.FORBID_URLHASHCB;
                }
                else {
                    return k9;
                }
            }
            else {
                return AliPlayerGlobalSettings.FORBID_URLHASHCB;
            }
        }
        else {
            return AliPlayerGlobalSettings.FORBID_URLHASHCB;
        }
    }
    static OnGetUrlHashCallbackInternal(h9) {
        let i9 = AliPlayerGlobalSettings.OnGetUrlHashCallback(h9);
        if (i9.length == 0 || i9 == AliPlayerGlobalSettings.FORBID_URLHASHCB) {
            i9 = AliPlayerGlobalSettings.OnGetUrlRemovedQueryMd5(h9);
        }
        if (i9.length == 0) {
            i9 = AliPlayerGlobalSettings.FORBID_URLHASHCB;
        }
        return i9;
    }
    static OnGetUrlRemovedQueryMd5(g9) {
        if (AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5) {
            return premierlibrary.nGetUrlRemoveQueryMd5(g9);
        }
        return "";
    }
    static getSdkVersion() {
        return premierlibrary.nGetSdkVersion();
    }
    static setOptionStr(e9, f9) {
        premierlibrary.nSetOptionStr(e9, f9);
    }
    static setOptionNum(c9, d9) {
        premierlibrary.nSetOptionInt(c9, d9);
    }
    static setDNSResolve(a9, b9) {
        premierlibrary.nSetDNSResolve(a9, b9);
    }
    static setUseHttp2(z8) {
        premierlibrary.nSetUseHttp2(z8);
    }
    static setIPResolveType(y8) {
        premierlibrary.nGlobalSettingSetIPResolveType(y8);
    }
    static setAudioStreamType(x8) {
        premierlibrary.nSetAudioStreamType(x8);
    }
    static enableAudioLowLatencyMode(w8) {
        premierlibrary.nEnableAudioLowLatencyMode(w8);
    }
    static forceAudioRendingFormat(s8, t8, u8, v8) {
        premierlibrary.nForceAudioRendingFormat(s8, t8, u8, v8);
    }
    static enableLocalCache(p8, q8, r8) {
        return premierlibrary.nEnableLocalCache(p8, q8, r8);
    }
    static setCacheFileClearConfig(m8, n8, o8) {
        premierlibrary.nSetCacheFileClearConfig(m8, n8, o8);
    }
    static clearCaches() {
        premierlibrary.nClearCaches();
    }
    static enableHttpDns(l8) {
        premierlibrary.nEnableHttpDns(l8);
    }
    static enableEnhancedHttpDns(k8) {
        premierlibrary.nEnableEnhancedHttpDns(k8);
    }
    static enableNetworkBalance(j8) {
        premierlibrary.nEnableNetworkBalance(j8);
    }
    static enableEnhancedNetworkBalance(i8) {
        premierlibrary.nEnableEnhancedNetworkBalance(i8);
    }
    static enableBufferToLocalCache(h8) {
        premierlibrary.nEnableBufferToLocalCache(h8);
    }
    static disableCrashUpload(g8) {
        premierlibrary.nDisableCrashUpload(g8);
    }
    static enableAdaptiveIpDegrade(f8) {
        premierlibrary.nEnableAdaptiveIpDegrade(f8);
    }
    static setCacheUrlHashCallback(e8) {
        AliPlayerGlobalSettings.sOnGetUrlHashCallback = e8;
        AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5 = false;
        premierlibrary.nSetCacheUrlHashCallback(AliPlayerGlobalSettings.getInstance(), e8 != null);
    }
    static setUrlHashCallbackRemoveQueryAndMd5() {
        AliPlayerGlobalSettings.sOnGetUrlHashCallback = null;
        AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5 = true;
        premierlibrary.nSetUrlHashCallbackRemoveQueryAndMd5();
    }
}
AliPlayerGlobalSettings.SET_PRE_CONNECT_DOMAIN = 0;
AliPlayerGlobalSettings.SET_DNS_PRIORITY_LOCAL_FIRST = 1;
AliPlayerGlobalSettings.ENABLE_H2_MULTIPLEX = 2;
AliPlayerGlobalSettings.SET_EXTRA_DATA = 3;
AliPlayerGlobalSettings.ENABLE_ANDROID_DECODE_REUSE = 4;
AliPlayerGlobalSettings.NOT_PAUSE_WHEN_PREPARING = 5;
AliPlayerGlobalSettings.ALLOW_RTS_DEGRADE = 6;
AliPlayerGlobalSettings.ENABLE_DECODER_FAST_FIRST_FRAME = 7;
AliPlayerGlobalSettings.DISABLE_CAPTURE_SCALE = 8;
AliPlayerGlobalSettings.MAX_ERROR_FRAMES_HARDWARE_DECODE = 15;
AliPlayerGlobalSettings.ENABLE_URL_REFRESH_ON_FORBIDDEN = 18;
AliPlayerGlobalSettings.SCENE_PLAYER = 0;
AliPlayerGlobalSettings.SCENE_LOADER = 1;
AliPlayerGlobalSettings.CodecType_H265 = 0;
AliPlayerGlobalSettings.FORBID_URLHASHCB = "forbid_UseUrlHashCb";
AliPlayerGlobalSettings.sOnGetUrlHashCallback = null;
AliPlayerGlobalSettings.isInternalUrlHashBackRemovedQueryAndMd5 = false;
export var AudioStreamType;
(function (d8) {
    d8[d8["AUDIOSTREAM_USAGE_UNKNOWN"] = 0] = "AUDIOSTREAM_USAGE_UNKNOWN";
    d8[d8["AUDIOSTREAM_USAGE_MUSIC"] = 1] = "AUDIOSTREAM_USAGE_MUSIC";
    d8[d8["AUDIOSTREAM_USAGE_VOICE_COMMUNICATION"] = 2] = "AUDIOSTREAM_USAGE_VOICE_COMMUNICATION";
    d8[d8["AUDIOSTREAM_USAGE_VOICE_ASSISTANT"] = 3] = "AUDIOSTREAM_USAGE_VOICE_ASSISTANT";
    d8[d8["AUDIOSTREAM_USAGE_ALARM"] = 4] = "AUDIOSTREAM_USAGE_ALARM";
    d8[d8["AUDIOSTREAM_USAGE_VOICE_MESSAGE"] = 5] = "AUDIOSTREAM_USAGE_VOICE_MESSAGE";
    d8[d8["AUDIOSTREAM_USAGE_RINGTONE"] = 6] = "AUDIOSTREAM_USAGE_RINGTONE";
    d8[d8["AUDIOSTREAM_USAGE_NOTIFICATION"] = 7] = "AUDIOSTREAM_USAGE_NOTIFICATION";
    d8[d8["AUDIOSTREAM_USAGE_ACCESSIBILITY"] = 8] = "AUDIOSTREAM_USAGE_ACCESSIBILITY";
    d8[d8["AUDIOSTREAM_USAGE_MOVIE"] = 10] = "AUDIOSTREAM_USAGE_MOVIE";
    d8[d8["AUDIOSTREAM_USAGE_GAME"] = 11] = "AUDIOSTREAM_USAGE_GAME";
    d8[d8["AUDIOSTREAM_USAGE_AUDIOBOOK"] = 12] = "AUDIOSTREAM_USAGE_AUDIOBOOK";
    d8[d8["AUDIOSTREAM_USAGE_NAVIGATION"] = 13] = "AUDIOSTREAM_USAGE_NAVIGATION";
    d8[d8["AUDIOSTREAM_USAGE_VIDEO_COMMUNICATION"] = 17] = "AUDIOSTREAM_USAGE_VIDEO_COMMUNICATION";
})(AudioStreamType || (AudioStreamType = {}));
