import premierlibrary from 'libpremierlibrary.so';
export class HlsKeyGenerator {
    static getInstance() {
        if (HlsKeyGenerator.instance == undefined) {
            HlsKeyGenerator.instance = new HlsKeyGenerator();
        }
        return HlsKeyGenerator.instance;
    }
    static setOnKeyGenerateListener(r24) {
        HlsKeyGenerator.getInstance().mOnKeyGenerateListener = r24;
    }
    constructor() {
        this.mOutKey = "default-key";
        this.getHlsOutKey = () => {
            return HlsKeyGenerator.getInstance().mOutKey;
        };
        this.onHlsKeyInfoInit = (o24, p24, q24) => {
            console.log('onHlsKeyInfoInit called.');
            if (this.mOnKeyGenerateListener != null) {
                this.mOnKeyGenerateListener.onHlsKeyInfoInit(o24, p24, q24);
            }
        };
        this.getHlsKey = (l24, m24) => {
            console.log('ongetHlsKey called.');
            if (this.mOnKeyGenerateListener != null) {
                let n24 = this.mOnKeyGenerateListener.getHlsKey(l24, m24);
                this.mOutKey = n24;
                console.log("get hlsKey, key: " + n24);
                return n24;
            }
            return "";
        };
        this.getHlsKeyInternal = () => {
            if (this.mOutKey) {
                return this.mOutKey;
            }
            return "";
        };
        premierlibrary.nHlsGenConstruct(this);
    }
}
