import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
import { Option, AudioStatus, } from '../IPlayer';
import { InfoBean } from '../bean/InfoBean';
import { findInfoCodeByValue, InfoCode } from '../bean/InfoCode';
import { findErrorCodeByValue } from '../bean/PlayerErrorCode';
import { ErrorInfo } from '../bean/ErrorInfo';
import { ObjCreateHelper } from '../../utils/ObjCreateHelper';
import { findNetworkLevelByCode } from './NetworkStats';
const log = new Log('NativePlayerBase');
export class NativePlayerBase {
    setHasListenerCallback(t33) {
        this.mHasListenerCallback = t33;
    }
    hasListener(s33) {
        if (this.mHasListenerCallback != null) {
            return this.mHasListenerCallback.hasListener(s33);
        }
        return false;
    }
    constructor(z29) {
        this.mNativeContext = BigInt(0);
        this.objHelper = new ObjCreateHelper();
        this.mHasListenerCallback = null;
        this.getNativeContext = () => {
            log.info(`getNativeContext, address: ${this.mNativeContext}`);
            return this.mNativeContext;
        };
        this.setNativeContext = (r33) => {
            log.info(`[addr check] setNativeContext, address: ${r33}`);
            this.mNativeContext = r33;
        };
        this.getHelper = () => {
            log.info(`getHelper`);
            return this.objHelper;
        };
        this.getContext = () => {
            log.info(`[addr check] getNativeContext, address: ${this.mNativeContext}`);
            return this.mContext;
        };
        this.onPrepared = () => {
            console.log('onPrepared called at nativePlayerBase.');
            if (this.mOnPreparedListener != null) {
                this.setOption('InOnPrepared', '1');
                this.mOnPreparedListener.onPrepared();
                this.setOption('InOnPrepared', '0');
            }
        };
        this.onCircleStart = () => {
            if (this.mOnInfoListener != null) {
                let q33 = new InfoBean();
                q33.setCode(InfoCode.LoopingStart);
                this.mOnInfoListener.onInfo(q33);
            }
        };
        this.onAutoPlayStart = () => {
            if (this.mOnInfoListener != null) {
                let p33 = new InfoBean();
                p33.setCode(InfoCode.AutoPlayStart);
                this.mOnInfoListener.onInfo(p33);
            }
        };
        this.onEvent = (l33, m33) => {
            if (this.mOnInfoListener != null) {
                let n33 = findInfoCodeByValue(l33);
                let o33 = new InfoBean();
                o33.setCode(n33);
                o33.setExtraMsg(m33);
                this.mOnInfoListener.onInfo(o33);
            }
        };
        this.onCurrentDownloadSpeed = (j33) => {
            if (this.mOnInfoListener != null) {
                let k33 = new InfoBean();
                k33.setCode(InfoCode.CurrentDownloadSpeed);
                k33.setExtraValue(j33);
                this.mOnInfoListener.onInfo(k33);
            }
        };
        this.onUtcTimeUpdate = (h33) => {
            if (this.mOnInfoListener != null) {
                let i33 = new InfoBean();
                i33.setCode(InfoCode.UtcTime);
                i33.setExtraValue(h33);
                this.mOnInfoListener.onInfo(i33);
            }
        };
        this.onLocalCacheLoad = (f33) => {
            if (this.mOnInfoListener != null) {
                let g33 = new InfoBean();
                g33.setCode(InfoCode.LocalCacheLoaded);
                g33.setExtraValue(f33);
                this.mOnInfoListener.onInfo(g33);
            }
        };
        this.onBufferedPositionUpdate = (d33) => {
            if (this.mOnInfoListener != null) {
                let e33 = new InfoBean();
                e33.setCode(InfoCode.BufferedPosition);
                e33.setExtraValue(d33);
                this.mOnInfoListener.onInfo(e33);
            }
        };
        this.onCurrentPositionUpdate = (b33) => {
            if (this.mOnInfoListener != null) {
                let c33 = new InfoBean();
                c33.setCode(InfoCode.CurrentPosition);
                c33.setExtraValue(b33);
                this.mOnInfoListener.onInfo(c33);
            }
        };
        this.onFirstFrameShow = () => {
            if (this.mOnRenderingStartListener != null) {
                this.mOnRenderingStartListener.onRenderingStart();
            }
        };
        this.onVideoSizeChanged = (z32, a33) => {
            if (this.mOnVideoSizeChangedListener != null) {
                this.mOnVideoSizeChangedListener.onVideoSizeChanged(z32, a33);
            }
        };
        this.onAudioInterruptEvent = (y32) => {
            if (this.mOnAudioInterruptEventListener != null) {
                if (y32 < AudioStatus.AUDIO_STATUS_DEFAULT || y32 > AudioStatus.AUDIO_STATUS_UNDUCK) {
                    log.info('onAudioInterruptEvent exception audioStatus: ' + y32);
                    this.mOnAudioInterruptEventListener.onAudioInterruptEvent(AudioStatus.AUDIO_STATUS_DEFAULT);
                    return;
                }
                this.mOnAudioInterruptEventListener.onAudioInterruptEvent(y32);
            }
        };
        this.onLoadingStart = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingBegin();
            }
        };
        this.onLoadingProgress = (x32) => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingProgress(x32, 0);
            }
        };
        this.onLoadingEnd = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingEnd();
            }
        };
        this.onAVNotSyncStart = (w32) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncStart(w32);
            }
        };
        this.onAVNotSyncEnd = (v32) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncEnd();
            }
        };
        this.onNetworkStats = (s32, t32) => {
            let u32 = findNetworkLevelByCode(t32);
            s32.networkLevel = u32;
            if (this.mOnNetworkStatsListener != null) {
                this.mOnNetworkStatsListener.onNetworkStats(s32);
            }
        };
        this.onSeekEnd = () => {
            if (this.mOnSeekCompleteListener != null) {
                this.mOnSeekCompleteListener.onSeekComplete();
            }
        };
        this.onStatusChanged = (q32, r32) => {
            log.info('onStatusChanged, newState: ' + q32 + ' oldState: ' + r32);
            if (this.mOnStateChangedListener != null) {
                this.mOnStateChangedListener.onStateChanged(q32);
            }
        };
        this.onCompletion = () => {
            if (this.mOnCompletionListener != null) {
                this.mOnCompletionListener.onCompletion();
            }
        };
        this.onVideoRendered = (o32, p32) => {
            if (this.mOnVideoRenderedListener != null) {
                this.mOnVideoRenderedListener.onVideoRendered(o32, p32);
            }
        };
        this.onShowSubtitle = (l32, m32, n32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleShow(l32, m32, n32);
            }
        };
        this.onSubtitleExtAdded = (j32, k32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleExtAdded(j32, k32);
            }
        };
        this.onHideSubtitle = (h32, i32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHide(h32, i32);
            }
        };
        this.onSubtitleHeader = (f32, g32) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHeader(f32, g32);
            }
        };
        this.onError = (a32, b32, c32) => {
            let d32 = findErrorCodeByValue(a32);
            if (this.mOnErrorListener != null) {
                let e32 = new ErrorInfo();
                e32.setCode(d32);
                e32.setMsg(b32);
                e32.setExtra(c32);
                this.mOnErrorListener.onError(e32);
            }
        };
        this.onUrlExpired = (z31) => {
            if (this.mOnUrlExpiredListener != null) {
                this.mOnUrlExpiredListener.onUrlExpired(z31, null);
            }
        };
        this.onStreamSwitchSuc = (y31) => {
            if (this.mOnTrackChangedListener != null) {
                this.mOnTrackChangedListener.onChangedSuccess(y31);
            }
        };
        this.onStreamInfoGet = (x31) => {
            if (this.mOnTrackReadyListener != null) {
                this.mOnTrackReadyListener.onTrackReady(x31);
            }
        };
        this.onSubStreamInfoGet = (w31) => {
            if (this.mOnSubTrackReadyListener != null) {
                this.mOnSubTrackReadyListener.onSubTrackReady(w31);
            }
        };
        this.onSwitchStreamUrlResult = (r31, s31, t31) => {
            if (this.mOnStreamSwitchedListener == null) {
                return;
            }
            if (s31 == 0) {
                this.mOnStreamSwitchedListener.onSwitchedSuccess(r31);
            }
            else {
                let u31 = findErrorCodeByValue(s31);
                let v31 = new ErrorInfo();
                v31.setCode(u31);
                v31.setMsg(t31);
                this.mOnStreamSwitchedListener.onSwitchedFail(r31, v31);
            }
        };
        this.onCaptureScreen = (o31, p31, q31) => {
            if (this.mOnSnapShotListener != null) {
                this.mOnSnapShotListener.onSnapShot(q31, o31, p31);
            }
        };
        this.onSeiDataCallback = (m31, n31) => {
            if (this.mOnSeiDataListener != null) {
                this.mOnSeiDataListener.onSeiData(m31, new Uint8Array(n31));
            }
        };
        log.info('constructor_');
        this.mContext = z29;
        premierlibrary.nConstruct(this);
    }
    setOnPreparedListener(y29) {
        this.mOnPreparedListener = y29;
    }
    setOnInfoListener(x29) {
        this.mOnInfoListener = x29;
    }
    setOnRenderingStartListener(w29) {
        this.mOnRenderingStartListener = w29;
    }
    setOnStateChangedListener(v29) {
        this.mOnStateChangedListener = v29;
    }
    setOnCompletionListener(u29) {
        this.mOnCompletionListener = u29;
    }
    setOnLoadingStatusListener(t29) {
        this.mOnLoadingStatusListener = t29;
    }
    setOnErrorListener(s29) {
        this.mOnErrorListener = s29;
    }
    setOnVideoSizeChangedListener(r29) {
        this.mOnVideoSizeChangedListener = r29;
    }
    setOnSeekCompleteListener(q29) {
        this.mOnSeekCompleteListener = q29;
    }
    setOnSubtitleDisplayListener(p29) {
        this.mOnSubtitleDisplayListener = p29;
    }
    setOnUrlExpiredListener(o29) {
        this.mOnUrlExpiredListener = o29;
    }
    setOnVideoRenderedListener(n29) {
        this.mOnVideoRenderedListener = n29;
    }
    setOnAudioInterruptEventListener(m29) {
        this.mOnAudioInterruptEventListener = m29;
    }
    setOnTrackReadyListener(l29) {
        this.mOnTrackReadyListener = l29;
    }
    setOnSubTrackReadyListener(k29) {
        this.mOnSubTrackReadyListener = k29;
    }
    setOnStreamSwitchedListener(j29) {
        this.mOnStreamSwitchedListener = j29;
    }
    setOnAVNotSyncStatusListener(i29) {
        this.mOnAVNotSyncStatusListener = i29;
    }
    setOnNetworkStatsListener(h29) {
        this.mOnNetworkStatsListener = h29;
    }
    setOnTrackChangedListener(g29) {
        this.mOnTrackChangedListener = g29;
    }
    setOnSnapShotListener(f29) {
        this.mOnSnapShotListener = f29;
    }
    setOnSeiDataListener(e29) {
        this.mOnSeiDataListener = e29;
    }
    start() {
        log.info('nStart');
        premierlibrary.nStart(this);
    }
    pause() {
        log.info('nPause');
        premierlibrary.nPause(this);
    }
    stop() {
        log.info('nStop');
        premierlibrary.nStop(this);
    }
    prepare() {
        log.info('nPrepare');
        premierlibrary.nPrepare(this);
    }
    setAutoPlay(d29) {
        log.info('nSetAutoPlay');
        premierlibrary.nSetAutoPlay(this, d29);
    }
    setSurfaceId(c29) {
        log.info('nSetSurfaceId');
        premierlibrary.nSetSurfaceId(this, c29);
    }
    setSpeed(b29) {
        log.info('setSpeed');
        premierlibrary.nSetSpeed(this, b29);
    }
    switchStream(a29) {
        log.info('switchStream');
        premierlibrary.nSwitchStream(this, a29);
    }
    setAlphaRenderMode(z28) {
        log.info('setAlphaRenderMode');
        premierlibrary.nSetAlphaRenderMode(this, z28);
    }
    getAlphaRenderMode() {
        log.info('getAlphaRenderMode');
        return premierlibrary.nGetAlphaRenderMode(this);
    }
    selectTrack(y28) {
        log.info('selectTrack');
        premierlibrary.nSelectTrack(this, y28);
    }
    getCurrentTrack(w28) {
        log.info('getCurrentTrack, type: ' + w28);
        let x28 = premierlibrary.nGetCurrentStreamInfo(this, w28);
        return x28;
    }
    addExtSubtitle(v28) {
        log.info(`addExtSubtitle`);
        premierlibrary.nAddExtSubtitle(this, v28);
    }
    selectExtSubtitle(t28, u28) {
        log.info(`selectExtSubtitle`);
        premierlibrary.nSelectExtSubtitle(this, t28, u28);
    }
    setVolume(s28) {
        log.info('setVolume');
        premierlibrary.nSetVolume(this, s28);
    }
    getVolume() {
        log.info('getVolume');
        return premierlibrary.nGetVolume(this);
    }
    seekTo(q28, r28) {
        log.info('seekTo');
        premierlibrary.nSeekTo(this, q28, r28);
    }
    setStartTime(o28, p28) {
        log.info('setStartTime');
        premierlibrary.nSetStartTime(this, o28, p28);
    }
    getDuration() {
        log.info('getDuration');
        return premierlibrary.nGetDuration(this);
    }
    setGlobalTime(n28) {
        premierlibrary.nSetGlobalTime(this, n28);
    }
    getPlayedDuration() {
        log.info('getPlayedDuration');
        return premierlibrary.nGetPlayedDuration(this);
    }
    getCurrentPosition() {
        log.info('getCurrentPosition');
        return premierlibrary.nGetCurrentPosition(this);
    }
    getBufferedPosition() {
        log.info('getBufferedPosition');
        return premierlibrary.nGetBufferedPosition(this);
    }
    getPlayerStatus() {
        log.info('getPlayerStatus');
        return premierlibrary.nGetPlayerStatus(this);
    }
    setTraceId(m28) {
        log.info('setTraceId');
        premierlibrary.nSetTraceId(this, m28);
    }
    enableHardwareDecoder(l28) {
        log.info('enableHardwareDecoder');
        premierlibrary.nEnableHardwareDecoder(this, l28);
    }
    release() {
        log.info('release');
        premierlibrary.nRelease(this);
    }
    setMute(k28) {
        log.info('setMute');
        premierlibrary.nSetMute(this, k28);
    }
    isMuted() {
        log.info('isMuted');
        return premierlibrary.nIsMuted(this) === 1;
    }
    setScaleMode(j28) {
        log.info('setScaleMode');
        premierlibrary.nSetScaleMode(this, j28);
    }
    getScaleMode() {
        log.info('getScaleMode');
        return premierlibrary.nGetScaleMode(this);
    }
    setLoop(i28) {
        log.info('setLoop');
        premierlibrary.nSetLoop(this, i28);
    }
    isLoop() {
        log.info('isLoop');
        return premierlibrary.nIsLoop(this) === 1;
    }
    getVideoWidth() {
        log.info('getVideoWidth');
        return premierlibrary.nGetVideoWidth(this);
    }
    getVideoHeight() {
        log.info('getVideoHeight');
        return premierlibrary.nGetVideoHeight(this);
    }
    getVideoRotation() {
        log.info('getVideoRotation');
        return premierlibrary.nGetVideoRotation(this);
    }
    reload() {
        log.info('reload');
        premierlibrary.nReload(this);
    }
    setRotateMode(h28) {
        log.info('setRotateMode');
        premierlibrary.nSetRotateMode(this, h28);
    }
    getRotateMode() {
        log.info('getRotateMode');
        return premierlibrary.nGetRotateMode(this);
    }
    setMirrorMode(g28) {
        log.info('setMirrorMode');
        premierlibrary.nSetMirrorMode(this, g28);
    }
    getMirrorMode() {
        log.info('getMirrorMode');
        return premierlibrary.nGetMirrorMode(this);
    }
    setVideoBackgroundColor(f28) {
        log.info('setVideoBackgroundColor');
        premierlibrary.nSetVideoBackgroundColor(this, f28);
    }
    getSpeed() {
        log.info('getSpeed');
        return premierlibrary.nGetSpeed(this);
    }
    isAutoPlay() {
        log.info('isAutoPlay');
        return premierlibrary.nIsAutoPlay(this) === 1;
    }
    isAutoBandWidth() {
        log.info('isAutoBandWidth');
        return premierlibrary.nIsAutoBandWidth(this) === 1;
    }
    setAutoBandWidth(e28) {
        log.info('nSetAutoBandWidth');
        premierlibrary.nSetAutoBandWidth(this, e28);
    }
    setConfig(d28) {
        log.info('setConfig');
        premierlibrary.nSetConfig(this, d28);
        this.mPlayerConfig = d28;
    }
    getConfig() {
        log.info('getConfig');
        let c28 = premierlibrary.nGetConfig(this);
        return c28;
    }
    setPlayerScene(b28) {
        log.info('setPlayerScene');
        premierlibrary.nSetPlayerScene(this, b28);
    }
    setOption(z27, a28) {
        log.info('setOption');
        premierlibrary.nSetOption(this, z27, a28);
    }
    getOption(w27) {
        let x27 = premierlibrary.nGetOption(this, w27);
        if (w27 == Option.RenderFPS ||
            w27 == Option.DownloadBitrate ||
            w27 == Option.VideoBitrate ||
            w27 == Option.AudioBitrate) {
            let y27 = parseFloat(x27);
            return y27;
        }
        return x27;
    }
    setStreamDelay(u27, v27) {
        log.info('setStreamDelay');
        premierlibrary.nSetStreamDelay(this, u27, v27);
    }
    setMaxAccurateSeekDelta(t27) {
        log.info('setMaxAccurateSeekDelta');
        premierlibrary.nSetMaxAccurateSeekDelta(this, t27);
    }
    setCacheConfig(s27) {
        log.info('setCacheConfig');
        premierlibrary.nSetCacheConfig(this, s27);
    }
    setIPResolveType(r27) {
        log.info('setIPResolveType');
        premierlibrary.nSetIPResolveType(this, r27);
    }
    setFastStart(q27) {
        log.info('setFastStart');
        premierlibrary.nSetFastStart(this, q27);
    }
    snapShot() {
        log.info('snapShot');
        premierlibrary.nSnapShot(this);
    }
    clearScreen() {
        log.info('clearScreen');
        premierlibrary.nClearScreen(this);
    }
    getSdkVersion() {
        log.info('getSdkVersion');
        return premierlibrary.nGetSdkVersion();
    }
    getCacheFilePathByUrl(p27) {
        log.info('getCacheFilePathByUrl');
        return premierlibrary.nGetCacheFilePathByUrl(this, p27);
    }
    getCacheFilePathByVid(l27, m27, n27, o27) {
        log.info('getCacheFilePathByVid');
        return premierlibrary.nGetCacheFilePathByVid(this, l27, m27, n27, o27);
    }
    getPropertyString(k27) {
        log.info('getPropertyString');
        return premierlibrary.nGetPropertyString(this, k27);
    }
    setDefaultBandWidth(j27) {
        log.info('setDefaultBandWidth');
        premierlibrary.nSetDefaultBandWidth(this, j27);
    }
    setDefaultResolution(i27) {
        log.info('setDefaultResolution');
        premierlibrary.nSetDefaultResolution(this, i27);
    }
    sendCustomEvent(h27) {
        log.info('sendCustomEvent');
        premierlibrary.nSendCustomEvent(this, h27);
    }
    setVideoTag(g27) {
        log.info('setVideoTag');
        premierlibrary.nSetVideoTag(this, g27);
    }
    setUserData(f27) {
        log.info('setUserData');
        premierlibrary.nSetUserData(this, f27);
    }
    getUserData() {
        log.info('getUserData');
        return premierlibrary.nGetUserData(this);
    }
    refreshPlayerUrl(e27) {
        log.info('refreshPlayerUrl');
        premierlibrary.nRefreshPlayerUrl(this, e27);
    }
    refreshPlayerUrlWithError(d27) {
        log.info('refreshPlayerUrlWithError');
        premierlibrary.nRefreshPlayerUrlWithError(this, d27);
    }
    getNativeContextAddr() {
        return this.mNativeContext;
    }
}
