import { NativePlayerBase } from './NativePlayerBase';
import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
const log = new Log('OhosUrlPlayer');
export class OhosUrlPlayer extends NativePlayerBase {
    setUrlDataSource(t35) {
        premierlibrary.nSetUrlDataSource(this, t35);
    }
    constructor(s35) {
        super(s35);
        this.mOnURLSourceExpiredListener = null;
    }
    setOnURLSourceExpiredListener(r35) {
        this.mOnURLSourceExpiredListener = r35;
    }
    refreshUrlSource(q35) {
        if (q35) {
            premierlibrary.nRefreshUrlSource(this, q35);
        }
    }
    refreshUrlSourceWithError(p35) {
        if (p35) {
            premierlibrary.nRefreshUrlSourceWithError(this, p35);
        }
    }
    onUrlSourceExpired(o35) {
        if (this.mOnURLSourceExpiredListener) {
            this.mOnURLSourceExpiredListener.onUrlSourceExpired(o35, null);
        }
    }
}
