import { AVPLBase } from './AVPLBase';
import { Log } from '../utils/Log';
import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
export class UrlVideoListPlayer extends AVPLBase {
    constructor(x46, y46) {
        super(x46, y46);
        this.mLog = new Log("NativePlayerBase_UrlVideoListPlayer");
        this.mUrlVideoPlayer = null;
        this.mUrlPrerenderPlayer = null;
    }
    setOnURLSourceExpiredListener(w46) {
        if (this.mUrlVideoPlayer != null) {
            this.mUrlVideoPlayer.setOnURLSourceExpiredListener(w46);
        }
    }
    createListPlayer(s46, t46, u46, v46) {
        return new OhosUrlListPlayer(s46, u46, v46, false);
    }
    getNativePlayerWithContext(q46, r46) {
        if (this.mUrlVideoPlayer == null) {
            this.mUrlVideoPlayer = new UrlVideoPlayer(q46, r46);
        }
        return this.mUrlVideoPlayer;
    }
    getPrerenderPlayerWithContext(o46, p46) {
        if (this.mUrlPrerenderPlayer == null) {
            this.mUrlPrerenderPlayer = new UrlVideoPlayer(o46, p46);
        }
        return this.mUrlPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let n46 = super.getCorePlayer();
        if (n46 instanceof OhosUrlListPlayer) {
            this.mLog.info("getCurrentPlayerIndex");
            return n46.getCurrentPlayerIndex();
        }
        return -1;
    }
    getPreRenderPlayer() {
        let l46 = super.getCorePlayer();
        if (l46 instanceof OhosUrlListPlayer) {
            this.mLog.info("getPreRenderPlayer");
            let m46 = l46.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(m46);
        }
        return undefined;
    }
    addUrl(i46, j46) {
        let k46 = super.getCorePlayer();
        if (k46 instanceof OhosUrlListPlayer) {
            this.mLog.info("addUrl = " + i46 + " , uid = " + j46);
            k46.addUrl(i46, j46);
        }
    }
    moveToNext() {
        let h46 = super.getCorePlayer();
        if (h46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNext");
            return h46.moveToNext(false);
        }
        return false;
    }
    moveToNextWithPrerendered() {
        let g46 = super.getCorePlayer();
        if (g46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNextWithPrerendered");
            return g46.moveToNext(true);
        }
        return false;
    }
    moveToPrev() {
        let f46 = super.getCorePlayer();
        if (f46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToPrev");
            return f46.moveToPrev();
        }
        return false;
    }
    moveTo(d46) {
        let e46 = super.getCorePlayer();
        if (e46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveTo");
            return e46.moveTo(d46);
        }
        return false;
    }
    setUrlDataSource(b46) {
        let c46 = super.getNativePlayer();
        if (c46.setUrlDataSource !== undefined) {
            c46.setUrlDataSource(b46);
        }
    }
}
