export var PreloadOptionType;
(function (j38) {
    j38["RESOLUTION"] = "RESOLUTION";
    j38["BANDWIDTH"] = "BANDWIDTH";
    j38["QUALITY"] = "QUALITY";
    j38["NONE"] = "NONE";
})(PreloadOptionType || (PreloadOptionType = {}));
export class PreloadConfig {
    constructor(x37) {
        this.mPreloadDuration = 1000;
        this.mNetworkTimeout = 15000;
        this.mNetworkRetryCount = 2;
        this.mReferrer = '';
        this.mCustomHeaders = [];
        this.mOptionType = PreloadOptionType.NONE;
        this.mOptionIntValue = 0;
        this.mOptionStringValue = '';
        this.nativeGetDefaultBandWidth = () => {
            let i38 = this.getDefaultBandWidth();
            return i38;
        };
        this.nativeGetDefaultResolution = () => {
            return this.getDefaultResolution();
        };
        this.nativeGetDefaultQuality = () => {
            return this.getDefaultQuality();
        };
        this.nativeGetDefaultType = () => {
            return this.getDefaultType().toString();
        };
        this.nativeGetDuration = () => {
            let h38 = this.getDuration();
            return this.getDuration();
        };
        this.nativeGetNetworkTimeout = () => {
            return this.getNetworkTimeout();
        };
        this.nativeGetNetworkRetryCount = () => {
            return this.getNetworkRetryCount();
        };
        this.nativeGetReferrer = () => {
            return this.getReferrer();
        };
        this.nativeGetCustomHeaders = () => {
            return this.getCustomHeaders();
        };
        if (x37 !== undefined) {
            this.mPreloadDuration = x37;
        }
    }
    getDuration() {
        return this.mPreloadDuration;
    }
    setDuration(w37) {
        this.mPreloadDuration = w37;
    }
    getNetworkTimeout() {
        return this.mNetworkTimeout;
    }
    setNetworkTimeout(v37) {
        this.mNetworkTimeout = v37;
    }
    getNetworkRetryCount() {
        return this.mNetworkRetryCount;
    }
    setNetworkRetryCount(u37) {
        this.mNetworkRetryCount = u37;
    }
    getReferrer() {
        return this.mReferrer;
    }
    setReferrer(t37) {
        this.mReferrer = t37;
    }
    getCustomHeaders() {
        return this.mCustomHeaders;
    }
    setCustomHeaders(s37) {
        this.mCustomHeaders = s37;
    }
    setDefaultResolution(r37) {
        this.mOptionType = PreloadOptionType.RESOLUTION;
        this.mOptionIntValue = r37;
        this.mOptionStringValue = '';
    }
    getDefaultResolution() {
        return (this.mOptionType === PreloadOptionType.RESOLUTION) ? this.mOptionIntValue : 0;
    }
    setDefaultBandWidth(q37) {
        this.mOptionType = PreloadOptionType.BANDWIDTH;
        this.mOptionIntValue = q37;
        this.mOptionStringValue = '';
    }
    getDefaultBandWidth() {
        return (this.mOptionType === PreloadOptionType.BANDWIDTH) ? this.mOptionIntValue : 0;
    }
    setDefaultQuality(p37) {
        this.mOptionType = PreloadOptionType.QUALITY;
        this.mOptionStringValue = p37;
        this.mOptionIntValue = 0;
    }
    getDefaultQuality() {
        return (this.mOptionType === PreloadOptionType.QUALITY) ? this.mOptionStringValue : '';
    }
    getDefaultType() {
        return this.mOptionType;
    }
}
