import { SourceBase } from './SourceBase';
import { Definition } from './Definition';
export class VidSourceBase extends SourceBase {
    constructor() {
        super();
        this.mPlayConfig = null;
        this.mOutputType = null;
        this.mStreamTypes = null;
        this.mResultType = null;
        this.mDigitalWatermarkType = null;
        this.nativeGetOutputTypeStr = () => {
            if (this.mOutputType == null) {
                return "";
            }
            else {
                return this.mOutputType.toString();
            }
        };
        this.nativeGetReAuthInfoStr = () => {
            return this.mReAuthInfo;
        };
        this.nativeGetResultTypeStr = () => {
            if (this.mResultType == null) {
                return "";
            }
            else {
                return this.mResultType;
            }
        };
        this.nativeGetStreamTypeStr = () => {
            if (this.mStreamTypes == null || this.mStreamTypes.size == 0) {
                return "";
            }
            let d45 = "";
            for (let e45 of this.mStreamTypes) {
                if (e45 != null) {
                    d45 += e45 + ",";
                }
            }
            if (d45.length > 0) {
                d45 = d45.slice(0, -1);
            }
            return d45;
        };
        this.nativeGetDefinitionStr = () => {
            if (this.mDefinitions == null || this.mDefinitions.length == 0) {
                return "";
            }
            if (this.mDefinitions.includes(Definition.DEFINITION_AUTO, 0)) {
                return Definition.DEFINITION_AUTO;
            }
            let b45 = "";
            for (let c45 of this.mDefinitions) {
                if (c45 != null) {
                    b45 += c45 + ",";
                }
            }
            if (b45.length > 0) {
                b45 = b45.slice(0, -1);
            }
            return b45;
        };
        this.nativeGetPlayerConfigStr = () => {
            if (this.mPlayConfig == null) {
                return "";
            }
            else {
                return this.mPlayConfig.genConfig();
            }
        };
        this.nativeGetFormatStr = () => {
            return this.getFormatStr();
        };
        this.nativeGetAuthTimeout = () => {
            return this.mAuthTimeout;
        };
        this.nativeGetTrace = () => {
            return this.mTrace;
        };
        this.nativeGetDigitalWatermarkTypeStr = () => {
            if (this.mDigitalWatermarkType == null) {
                return "";
            }
            else {
                return this.mDigitalWatermarkType.toString();
            }
        };
        this.mFormats = [];
        this.mDefinitions = [];
        this.mReAuthInfo = "";
        this.mAuthTimeout = 3600;
        this.mTrace = "";
    }
    getPlayerConfig() {
        if (this.mPlayConfig == null) {
            return "";
        }
        else {
            return this.mPlayConfig.genConfig();
        }
    }
    setPlayerConfig(q44) {
        this.mPlayConfig = q44;
    }
    getFormats() {
        return this.mFormats;
    }
    setFormats(p44) {
        this.mFormats = p44;
    }
    getFormatStr() {
        if (this.mFormats.length == 0) {
            return "";
        }
        let n44 = "";
        for (let o44 of this.mFormats) {
            if (o44 != null) {
                n44 += o44 + ",";
            }
        }
        if (n44.length > 0) {
            n44 = n44.slice(0, -1);
        }
        return n44;
    }
    setDefinition(m44) {
        this.mDefinitions = m44;
    }
    getOutputType() {
        return this.mOutputType;
    }
    setOutputType(l44) {
        this.mOutputType = l44;
    }
    setAuthTimeout(k44) {
        this.mAuthTimeout = k44;
    }
    setTrace(j44) {
        this.mTrace = j44;
    }
    setDigitalWatermarkType(i44) {
        this.mDigitalWatermarkType = i44;
    }
    getTrace() {
        return this.mTrace;
    }
    getDigitalWatermarkType() {
        return this.mDigitalWatermarkType;
    }
}
export var OutputType;
(function (h44) {
    h44["oss"] = "oss";
    h44["cdn"] = "cdn";
})(OutputType || (OutputType = {}));
export var StreamType;
(function (g44) {
    g44["video"] = "video";
    g44["audio"] = "audio";
})(StreamType || (StreamType = {}));
export var ResultType;
(function (f44) {
    f44["Single"] = "Single";
    f44["Multiple"] = "Multiple";
})(ResultType || (ResultType = {}));
export var DigitalWatermarkType;
(function (e44) {
    e44["TraceMark"] = "TraceMark";
    e44["CopyrightMark"] = "CopyrightMark";
})(DigitalWatermarkType || (DigitalWatermarkType = {}));
