"use strict";var __importDefault=this&&this.__importDefault||function(s){return s&&s.__esModule?s:{default:s}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.CrossplatformAppPlugin=void 0;const hvigor_1=require("@ohos/hvigor"),cross_platform_service_js_1=require("../service/cross-platform-service.js"),sync_project_js_1=require("../task/sync/sync-project.js"),clear_js_1=require("../task/clear.js"),package_as_app_js_1=require("../task/package-as-app.js"),package_ios_app_js_1=require("../task/package-ios-app.js"),find_target_product_js_1=require("@ohos/hvigor-ohos-plugin/src/common/find-target-product.js"),ohos_logger_js_1=require("@ohos/hvigor-ohos-plugin/src/utils/log/ohos-logger.js"),task_names_js_1=require("@ohos/hvigor-ohos-plugin/src/tasks/common/task-names.js");var SyncTask=task_names_js_1.TaskNames.SyncTask;const file_const_1=require("../common/const/file-const"),sdk_path_const_1=require("../common/const/sdk-path-const"),crossplatform_const_js_1=require("@ohos/hvigor-ohos-plugin/src/const/crossplatform-const.js"),path_1=__importDefault(require("path")),fs_1=__importDefault(require("fs")),fs_extra_1=__importDefault(require("fs-extra"));class CrossplatformAppPlugin{constructor(s){this.log=ohos_logger_js_1.OhosLogger.getLogger(CrossplatformAppPlugin.name),this.appPlugin=s,this._project=s._project,this._projectModel=s.getProjectModel();const e=SyncTask.syncTaskName(this._project.getName());this.syncProject=this._project.getTaskByName(e),this.clean=this._project.getTaskByName(task_names_js_1.TaskNames.CommonTask.CLEAN.name),this.assembleApp=this._project.getTaskByName(task_names_js_1.TaskNames.CommonHookTask.ASSEMBLE_APP.name)}initCrossPlatformService(){cross_platform_service_js_1.crossPlatformService.initService(this._projectModel)}async initHookTask(){if(!this.preCheck())return;(0,hvigor_1.isMac)()&&this.initIosTask(),this.initAndroidTask();const s=new sync_project_js_1.SyncProject(this._project);this.syncProject.dependsOn(s);const e=new clear_js_1.Clear(this._project);this.clean.dependsOn(e),this._project.registry(e),this._project.registry(s)}initAndroidTask(){const s=new package_as_app_js_1.PackageAsApp(this._project);this.assembleApp.dependsOn(s),this._project.registry(s)}initIosTask(){const s=new package_ios_app_js_1.PackageIosApp(this._project);this.assembleApp.dependsOn(s),this._project.registry(s)}preCheck(){return!!cross_platform_service_js_1.crossPlatformService.isCrossPlatform}checkProject(){this.checkArkUIXProfile(),this.checkApiVersion(),this.checkAndroidProject()}checkApiVersion(){const s=(0,find_target_product_js_1.findTargetProduct)(this._projectModel);this._projectModel.getCompileApiMetaByProduct(s.name).version<10&&this.log._buildError("The ArkUI cross-platform project requires that the API version be 10 or later.")._detail("Change the value of compatibleSdkVersion in build_profile.json5 to 10 or later.")._file(this._projectModel.getProfilePath())._printErrorAndExit()}checkAndroidProject(){const s=path_1.default.resolve(cross_platform_service_js_1.crossPlatformService.getPathInfo().getAndroidProjectDir(),file_const_1.FileConst.LOCAL_PROPERTIES);this.readFile(s).split(/\r?\n/).forEach((e=>{this.validateSdkDir(e,s)}))}readFile(s){return fs_1.default.existsSync(s)?fs_1.default.readFileSync(s,{encoding:"utf-8"}):""}validateSdkDir(s,e){if(!s||!s.trim())return;const r=/^([^#=]+)(={0,1})(.*)$/.exec(s),t=(0,hvigor_1.isWindows)()?/(([A-z]):)((\/|\\\\)[a-zA-Z0-9-_.()\s]+)*((\/|\\\\)?)$/:/^(\/([a-zA-Z0-9-_.()\s]+))+(\/?)$/;r&&r[1].trim()===sdk_path_const_1.SdkPathConst.SDK_DIR&&(t.test(r[3])||this.log._buildError("sdk.dir is invalid,Please check and repair")._file(e)._printErrorAndExit())}checkArkUIXProfile(){const s=cross_platform_service_js_1.crossPlatformService.getPathInfo().getArkUIXProjectRootPath(),e=cross_platform_service_js_1.crossPlatformService.getPathInfo().getArkUIXConfigJsonPath();fs_extra_1.default.existsSync(s)&&!fs_extra_1.default.existsSync(e)&&cross_platform_service_js_1.logger._buildError(`Cannot find the ArkUI-X project configuration file '${crossplatform_const_js_1.ARKUIX_CONFIG_JSON5}'.`)._detail("Ensure that the file exists.")._file(s)._printErrorAndExit()}}exports.CrossplatformAppPlugin=CrossplatformAppPlugin;