"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.basicCompareArray = exports.basicCompareMap = exports.basicCompareSet = exports.basicCompareObject = exports.basicCompare = exports.wrapIteratee = exports.warpIterateeFromKey = exports.wrapIterateeFromObject = exports.getValidIndex = exports.checkArrayLenValid = exports.ArrayDirection = exports.CompareModel = void 0;
var getType_1 = require("./getType");
var CompareModel;
(function (CompareModel) {
    CompareModel["EQUAL"] = "equal";
    CompareModel["INCLUDE"] = "include";
})(CompareModel = exports.CompareModel || (exports.CompareModel = {}));
var ArrayDirection;
(function (ArrayDirection) {
    ArrayDirection["LEFT"] = "left";
    ArrayDirection["RIGHT"] = "right";
})(ArrayDirection = exports.ArrayDirection || (exports.ArrayDirection = {}));
function checkArrayLenValid(target) {
    if (target == null) {
        return true;
    }
    return !target.length || target.length === 0;
}
exports.checkArrayLenValid = checkArrayLenValid;
function getValidIndex(target, defaultVal) {
    if (target === void 0) { target = 0; }
    if (defaultVal === void 0) { defaultVal = 0; }
    if (target == null) {
        return defaultVal;
    }
    if (target === Infinity || target === -Infinity) {
        return target > 0 ? Number.MAX_SAFE_INTEGER : Number.MIN_SAFE_INTEGER;
    }
    var result = Number.isInteger(target)
        ? target
        : Number.parseInt(target, 10);
    if (Number.isNaN(result)) {
        return defaultVal;
    }
    return result;
}
exports.getValidIndex = getValidIndex;
/**
 * 将目标对象包装成一个迭代函数
 * @param target
 * @returns
 */
function wrapIterateeFromObject(target) {
    return function (data) {
        return basicCompare(data, target);
    };
}
exports.wrapIterateeFromObject = wrapIterateeFromObject;
/**
 * 判断指定的key在目标对象是否存在，且对象非空
 * @param key
 * @returns
 */
function warpIterateeFromKey(key) {
    return function (data) {
        if (data == null) {
            return undefined;
        }
        if (key && key in data) {
            return data[key];
        }
        return undefined;
    };
}
exports.warpIterateeFromKey = warpIterateeFromKey;
/**
 * 针对对象(语法糖类似)来包装成迭代器函数。
 * @param fn
 * @returns
 */
function wrapIteratee(fn) {
    var _a;
    if (typeof fn === 'function') {
        return fn;
    }
    if (typeof fn === 'object') {
        return wrapIterateeFromObject(Array.isArray(fn) ? (_a = {}, _a[fn[0]] = fn[1], _a) : fn);
    }
    return warpIterateeFromKey(fn);
}
exports.wrapIteratee = wrapIteratee;
/**
 * 深度比对元素
 * @param source
 * @param target
 * @returns
 */
function basicCompare(source, target, compareModel) {
    if (compareModel === void 0) { compareModel = CompareModel.INCLUDE; }
    // 如果类型不同，直接返回false
    if (typeof source !== typeof target) {
        return false;
    }
    // 如果是基本类型，直接比较
    if (typeof source !== 'object') {
        return source === target;
    }
    // object类型下在分析对比子类别
    var sourceType = (0, getType_1.getType)(source);
    var targeType = (0, getType_1.getType)(target);
    if (sourceType !== targeType) {
        return false;
    }
    // 对象对比
    if (sourceType === getType_1.ObjType.Object) {
        return basicCompareObject(source, target, compareModel);
    }
    // 如果是数组，递归比较每一项
    if (sourceType === getType_1.ObjType.Array) {
        return basicCompareArray(source, target, compareModel);
    }
    //  weakMap 不支持迭代
    if (sourceType === getType_1.ObjType.Map) {
        return basicCompareMap(source, target, compareModel);
    }
    //  weakSet 不支持迭代遍历
    if (sourceType === getType_1.ObjType.Set) {
        return basicCompareSet(source, target, compareModel);
    }
    if (sourceType === getType_1.ObjType.Error) {
        return source.name === target.name && source.message === target.message;
    }
    return source === target;
}
exports.basicCompare = basicCompare;
/**
 * 对比Object
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
function basicCompareObject(source, target, compareModel) {
    var e_1, _a;
    if (compareModel === void 0) { compareModel = CompareModel.INCLUDE; }
    var sKeys = Object.keys(source);
    var tKeys = Object.keys(target);
    if (sKeys.length === 0 && tKeys.length === 0) {
        return true;
    }
    if (tKeys.length > sKeys.length) {
        return false;
    }
    try {
        for (var tKeys_1 = __values(tKeys), tKeys_1_1 = tKeys_1.next(); !tKeys_1_1.done; tKeys_1_1 = tKeys_1.next()) {
            var tKey = tKeys_1_1.value;
            if (!sKeys.includes(tKey)) {
                return false;
            }
            if (!basicCompare(source[tKey], target[tKey], compareModel)) {
                return false;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (tKeys_1_1 && !tKeys_1_1.done && (_a = tKeys_1.return)) _a.call(tKeys_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return true;
}
exports.basicCompareObject = basicCompareObject;
/**
 * 对比Set
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
function basicCompareSet(source, target, compareModel) {
    var e_2, _a, e_3, _b;
    if (compareModel === void 0) { compareModel = CompareModel.INCLUDE; }
    var sSize = source.size;
    var tSize = target.size;
    if (sSize === 0 && tSize === 0) {
        return true;
    }
    if (tSize > sSize) {
        return false;
    }
    try {
        for (var target_1 = __values(target), target_1_1 = target_1.next(); !target_1_1.done; target_1_1 = target_1.next()) {
            var tItem = target_1_1.value;
            try {
                for (var source_1 = (e_3 = void 0, __values(source)), source_1_1 = source_1.next(); !source_1_1.done; source_1_1 = source_1.next()) {
                    var sItem = source_1_1.value;
                    if (!basicCompare(sItem, tItem, compareModel)) {
                        return false;
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (source_1_1 && !source_1_1.done && (_b = source_1.return)) _b.call(source_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (target_1_1 && !target_1_1.done && (_a = target_1.return)) _a.call(target_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return true;
}
exports.basicCompareSet = basicCompareSet;
/**
 * 对比map
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
function basicCompareMap(source, target, compareModel) {
    var e_4, _a;
    if (compareModel === void 0) { compareModel = CompareModel.INCLUDE; }
    // 内部不处理非空等，在外面已经处理了
    var sSize = source.size;
    var tSize = target.size;
    if (sSize === 0 && tSize === 0) {
        return true;
    }
    if (tSize > sSize) {
        return false;
    }
    try {
        for (var _b = __values(target.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var tKey = _c.value;
            if (!source.has(tKey)
                || !basicCompare(source.get(tKey), target.get(tKey), compareModel)) {
                return false;
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return true;
}
exports.basicCompareMap = basicCompareMap;
/**
 * 对比数组
 * @param source
 * @param target
 * @param compareModel
 * @returns
 */
function basicCompareArray(source, target, compareModel) {
    if (compareModel === void 0) { compareModel = CompareModel.INCLUDE; }
    // 内部不处理非空等，在外面已经处理了
    var sourceLen = source.length;
    var targetLen = target.length;
    if (sourceLen === 0 && targetLen === 0) {
        return true;
    }
    // 包含模式：目标数组是源数组的一个连续子片段
    if (compareModel !== CompareModel.INCLUDE) {
        // TODO
        return sourceLen === targetLen;
    }
    if (targetLen > sourceLen) {
        return false;
    }
    // 判断目标数组是不是原数组的某一个片段
    for (var i = 0; i < sourceLen; i++) {
        if (basicCompare(source[i], target[0])) {
            // 找到了目标数组的第一个元
            var isChildren = true;
            for (var j = 1; j < targetLen; j++) {
                if (!basicCompare(source[i + j], target[j])) {
                    isChildren = false;
                    // break?
                    return false;
                }
            }
            if (isChildren) {
                return true;
            }
        }
    }
    return false;
}
exports.basicCompareArray = basicCompareArray;
