"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProperties = void 0;
var isKey_1 = require("./isKey");
var toKey_1 = require("./toKey");
var getDeepProperties_1 = require("./getDeepProperties");
/**
 * 根据对象路径获取对象的vlue数组.
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function getProperties(path) {
    return (0, isKey_1.isKey)(path) ? getBaseProperty((0, toKey_1.toKey)(path)) : (0, getDeepProperties_1.getDeepProperties)(path);
}
exports.getProperties = getProperties;
// 简单key，为单独的值
function getBaseProperty(key) {
    return function basePropertyR(obj) {
        return obj == null ? undefined : obj[key];
    };
}
