/**
 * 比较两个值完全一致，包括类型。
 * 详细参看标准 [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 *
 * @category Lang
 * @param {*} value 待比较的对象
 * @param {*} other 被比较的对象.
 * @returns {boolean} 如果相等则返回 `true`，否则返回 `false`.
 * @example
 *
 * const object = { 'a': 1 }
 * const other = { 'a': 1 }
 *
 * eq(object, object)
 * // => true
 *
 * eq(object, other)
 * // => false
 *
 * eq('a', 'a')
 * // => true
 *
 * eq('a', Object('a'))
 * // => false
 *
 * eq(NaN, NaN)
 * // => true
 */
export default function eq(value?: any, other?: any): boolean;
