"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var lastIndexOf_1 = require("./lastIndexOf");
var baseCompare_1 = require("./common/baseCompare");
function findIndexCore(array, predicate, startIndex) {
    if (startIndex === void 0) { startIndex = 0; }
    for (var i = (startIndex > array.length - 1 ? array.length - 1 : startIndex); i >= 0; i--) {
        if (predicate(array[i], i, array)) {
            return i;
        }
    }
    return -1;
}
/**
 * 在数组中，自右向左查找出满足条件的第一个元素的索引
 * 返回找到元素的 索引值（index），否则返回 -1
 * @param array
 * @param predicate
 * @param start
 */
function findLastIndex(array, predicate, start) {
    if ((0, baseCompare_1.checkArrayLenValid)(array)) {
        return -1;
    }
    try {
        var startIndex = (0, lastIndexOf_1.getStartIndex)(array, start);
        return findIndexCore(array, (0, baseCompare_1.wrapIteratee)(predicate), startIndex);
    }
    catch (e) {
        return -1;
    }
}
exports.default = findLastIndex;
