"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var keys_1 = __importDefault(require("./keys"));
function convertValueToKey(input) {
    var value = input;
    if (value !== null && typeof value.toString !== 'function') {
        value = toString.call(value);
    }
    return "".concat(value);
}
/**
 * 创建一个object键值倒置后的对象。 如果 object 有重复的值，后面的值会覆盖前面的值。
 * 返回新的键值倒置后的对象。
 * @param input
 */
function invert(input) {
    var result = {};
    var keyList = (0, keys_1.default)(input);
    if (keyList.length === 0) {
        return result;
    }
    keyList.forEach(function (eachKey) {
        var newKey = convertValueToKey(input[eachKey]);
        result[newKey] = eachKey;
    });
    return result;
}
exports.default = invert;
