"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isMatch_1 = __importDefault(require("./isMatch"));
var cloneDeep_1 = __importDefault(require("./cloneDeep"));
/**
 * 返回一个函数，该函数接受一个输入obj，并调用wdk.isMatch(source)返回两者是否匹配
 * @param source，进行比较的参考对象
 * @return 一个函数，执行后返回其入参和source进行isMatch比较的结果
 */
function matches(source) {
    var tmpSource = (0, cloneDeep_1.default)(source); // 克隆的tmpSource作为isMatch函数的输入，防止外界对source的修改会影响比较结果
    var isMatchSource = function (obj) {
        return (0, isMatch_1.default)(obj, tmpSource);
    };
    return isMatchSource;
}
exports.default = matches;
