"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var toNumber_1 = __importDefault(require("./toNumber"));
var toString_1 = __importDefault(require("./toString"));
/**
 * 如果string字符串长度小于 length 则在左侧填充字符。 如果超出length长度则截断超出的部分。
 * @param input   要填充的字符串
 * @param length  填充的长度
 * @param chars   填充的字符
 */
function padStart(input, length, chars) {
    var inputStr = (0, toString_1.default)(input);
    var len = (0, toNumber_1.default)(length);
    var charStr = chars === undefined ? ' ' : (0, toString_1.default)(chars);
    if (len <= inputStr.length || charStr === '') {
        return inputStr;
    }
    var paddingRes = '';
    for (var i = 0; i < (length - inputStr.length); i++) {
        paddingRes += charStr;
        if ("".concat(paddingRes).concat(inputStr).length >= length) {
            break;
        }
    }
    if ("".concat(paddingRes).concat(inputStr).length > length) {
        var extraLen = "".concat(paddingRes).concat(inputStr).length - length;
        paddingRes = paddingRes.substring(0, paddingRes.length - extraLen);
    }
    return "".concat(paddingRes).concat(inputStr);
}
exports.default = padStart;
