"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
var keys_1 = __importDefault(require("./keys"));
/**
 * 根据obj对象得到其中key-value键值对组成的数组。obj可以是Map或者Set类型，如果是Set，则key为数字下标（从1开始）
 * @param obj，一个对象（或者Map或者Set），用于生成键值对数组
 * @param isWithProtoChain，一个boolean，表示是否要包含原型链上的键值对
 * @return 一个二维数组，即根据obj生成的键值对数组
 */
function toPairs(obj, isWithProtoChain) {
    var objTagName = (0, utils_1.tagName)(obj);
    if (objTagName === '[object Map]') {
        return Array.from(obj.entries());
    }
    var keyList = [];
    var valueList = [];
    if (objTagName === '[object Set]') {
        // 如果obj是Set，则把Set中的元素当做value，其在Set中的序号（从1开始算起而不是0）当做key
        valueList = __spreadArray([], __read(obj), false);
        keyList = valueList.map(function (_v, index) { return index + 1; });
    }
    else {
        keyList = isWithProtoChain ? (0, utils_1.getObjectKeysWithProtoChain)(obj) : (0, keys_1.default)(obj);
        valueList = keyList.map(function (key) { return obj[key]; });
    }
    return keyList.map(function (key, index) { return [key, valueList[index]]; });
}
exports.default = toPairs;
