"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var getMaxLength = function (input) {
    var e_1, _a;
    var maxLength = 0;
    try {
        for (var input_1 = __values(input), input_1_1 = input_1.next(); !input_1_1.done; input_1_1 = input_1.next()) {
            var item = input_1_1.value;
            if ((0, isArrayLike_1.default)(item) && typeof item !== 'string' && item.length > maxLength) {
                maxLength = item.length;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (input_1_1 && !input_1_1.done && (_a = input_1.return)) _a.call(input_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return maxLength;
};
/**
 * 创建一个分组元素的数组，数组的第一个元素包含所有给定数组的第一个元素，数组的第二个元素包含所有给定数组的第二个元素，以此类推。
 *
 * @param input(...array) 要处理的数组
 * @returns array 返回分组元素的新数组
 *
 * @example
 * _.zip(['fred', 'barney'], [30, 40], [true, false]);
 * // => [['fred', 30, true], ['barney', 40, false]]
 */
function zip() {
    var e_2, _a;
    var input = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        input[_i] = arguments[_i];
    }
    if (!(0, isArrayLike_1.default)(input) && typeof input !== 'string') {
        return [];
    }
    var result = [];
    var maxLength = getMaxLength(input);
    for (var i = 0; i < maxLength; i++) {
        var tempRes = [];
        try {
            for (var input_2 = (e_2 = void 0, __values(input)), input_2_1 = input_2.next(); !input_2_1.done; input_2_1 = input_2.next()) {
                var item = input_2_1.value;
                if ((0, isArrayLike_1.default)(item) && typeof item !== 'string') {
                    tempRes.push(item[i]);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (input_2_1 && !input_2_1.done && (_a = input_2.return)) _a.call(input_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        result.push(tempRes);
    }
    return result;
}
exports.default = zip;
