"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateTemplateFile = void 0;
const fs = require("fs");
const path = require("path");
const testTemplate_1 = require("./testTemplate");
const pageIndexPath = '.test/testability/pages/Index.ets';
const testAbilityPath = '.test/testability/TestAbility.ets';
const phoneSettingPath = '.test/testability/phoneSettingConfig_Phone.json';
/**
 * 将模板文件生成到临时目录.test下
 * @param testTemplateParam
 */
const generateTemplateFile = (testTemplateParam) => {
    const modulePath = testTemplateParam.modulePath;
    const pageIndexTemplatePath = path.join(modulePath, pageIndexPath);
    const testAbilityTemplatePath = path.join(modulePath, testAbilityPath);
    const phoneSettingTemplatePath = path.join(modulePath, phoneSettingPath);
    const pageIndexStr = (0, testTemplate_1.pageIndexTemplate)(testTemplateParam);
    const testAbilityStr = (0, testTemplate_1.testAbilityTemplate)();
    const phoneSettingStr = (0, testTemplate_1.phoneSettingConfigTemplate)();
    if (!fs.existsSync(pageIndexTemplatePath)) {
        fs.mkdirSync(path.dirname(pageIndexTemplatePath), { recursive: true });
    }
    if (!fs.existsSync(testAbilityTemplatePath)) {
        fs.mkdirSync(path.dirname(testAbilityTemplatePath), { recursive: true });
    }
    fs.writeFileSync(pageIndexTemplatePath, pageIndexStr);
    fs.writeFileSync(testAbilityTemplatePath, testAbilityStr);
    fs.writeFileSync(phoneSettingTemplatePath, phoneSettingStr);
};
exports.generateTemplateFile = generateTemplateFile;
