"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeCoverageTest = void 0;
const path = require("path");
const fs = require("fs");
const node_child_process_1 = require("node:child_process");
const string_decoder_1 = require("string_decoder");
const coverageParser_1 = require("./coverageParser");
const portutil_1 = require("./portutil");
const decoder = new string_decoder_1.StringDecoder('utf8');
const abcDir = '.test/default/intermediates/assets/default/ets';
const resoucrceDir = '.test/default/intermediates/res/default';
const previewPath = '.test/default/intermediates/test/coverage_data/previewer.log';
const phonePath = '.test/testability/phoneSettingConfig_Phone.json';
const importHsp = 'Importing shared package in the Previewer';
const getSpawnChild = (previewerFullDir, abcDirectory, phoneConfigPath, resourceDirectory, portNum) => {
    let previewerCommand = previewerFullDir;
    if (process.platform === 'win32') {
        previewerCommand = path.join(previewerFullDir, 'Previewer.exe');
    }
    else if (process.platform === 'darwin') {
        previewerCommand = path.join(previewerFullDir, 'Previewer');
    }
    const child = (0, node_child_process_1.spawn)(previewerCommand, [
        '-refresh', 'region',
        '-projectID', '743055776',
        '-ts', 'trace_7947_commandPipe',
        '-j', abcDirectory,
        '-s', 'phone_1702972840143_1',
        '-cpm', 'false',
        '-device', 'phone',
        '-shape', 'rect',
        '-sd', '480',
        '-or', '1080', '2340',
        '-cr', '1080', '2340',
        '-f', phoneConfigPath,
        '-n', 'entry',
        '-av', 'ACE_2_0',
        '-p', '15038',
        '-url', '../../../.test/testability/pages/Index',
        '-pages', 'main_pages',
        '-arp', resourceDirectory,
        '-pm', 'Stage',
        '-l', 'zh_CN',
        '-cm', 'light',
        '-o', 'portrait',
        '-lws', portNum,
    ], { windowsHide: true, cwd: previewerFullDir });
    return child;
};
const executeCoverageTest = async (testPreviewerParam) => {
    const sdkApiPath = testPreviewerParam.sdkApiPath;
    const modulePath = testPreviewerParam.modulePath;
    const Logger = testPreviewerParam.logger;
    let previewerFullDir = path.join(sdkApiPath, '/common/bin');
    const abcDirectory = path.join(modulePath, abcDir);
    const resourceDirectory = path.join(modulePath, resoucrceDir);
    const previewDirectory = path.join(modulePath, previewPath);
    const phoneConfigPath = path.join(modulePath, phonePath);
    if (fs.existsSync(previewDirectory)) {
        fs.unlinkSync(previewDirectory);
    }
    if (!fs.existsSync(previewDirectory)) {
        fs.mkdirSync(path.dirname(previewDirectory), { recursive: true });
    }
    const portNum = (0, portutil_1.findPort)(40000, 0);
    if (portNum < 0) {
        Logger.error('No port available');
        return new Promise((resolve) => {
            resolve();
        });
    }
    let previewPromise = new Promise((resolve, reject) => {
        const child = getSpawnChild(previewerFullDir, abcDirectory, phoneConfigPath, resourceDirectory, `${portNum}`);
        child.stdout.on('data', (data) => {
            let previewData = decoder.write(data);
            try {
                fs.writeFileSync(previewDirectory, data, { flag: 'a+' });
                // file written successfully
                identifyImportHsp(previewData);
            }
            catch (err) {
                reject(err);
            }
            if (data.indexOf('The AbilityDelegator.finishTest') > -1) {
                child.kill();
                (0, coverageParser_1.parseCoverageData)(testPreviewerParam)
                    .then(() => {
                    resolve();
                })
                    .catch(reject);
            }
        });
    });
    return previewPromise;
};
exports.executeCoverageTest = executeCoverageTest;
const identifyImportHsp = (line) => {
    let classIndex = line.indexOf(importHsp);
    if (classIndex != -1) {
        throw new Error('Importing shared package is not supported');
    }
};
