"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.phoneSettingConfigTemplate = exports.testAbilityTemplate = exports.pageIndexTemplate = void 0;
const buildStr = `
  build() {
    Row() {
      Column() {
        Text(this.message)
          .fontSize(50)
          .fontWeight(FontWeight.Bold)
        Button() {
          Text('next page')
            .fontSize(20)
            .fontWeight(FontWeight.Bold)
        }
        .type(ButtonType.Capsule)
        .margin({
          top: 20
        })
        .backgroundColor('#0D9FFB')
        .width('35%')
        .height('5%')
        .onClick(() => {
        })
      }
      .width('100%')
    }
    .height('100%')
  }
`;
/**
 * 获取pageIndex模板
 * @testTemplateParam { testTemplateParam }
 * @returns
 */
const pageIndexTemplate = (testTemplateParam) => {
    let isCoverage = testTemplateParam.coverage === false ? false : true;
    let scope = testTemplateParam.scope ? testTemplateParam.scope : '';
    const pageIndexStr = `
    import hilog from '@ohos.hilog';
    import AbilityDelegatorRegistry from '@ohos.app.ability.abilityDelegatorRegistry'

    import {Hypium} from '@ohos/hypium'
    import testsuite from '../../../src/test/List.test'

    @Entry
    @Component
    struct Index1 {
      aboutToAppear() {
        console.info('[LOCAL_TEST] START')
        let abilityDelegator: AbilityDelegatorRegistry.AbilityDelegator;
        abilityDelegator = AbilityDelegatorRegistry.getAbilityDelegator();
        let abilityDelegatorArguments: AbilityDelegatorRegistry.AbilityDelegatorArgs;
        abilityDelegatorArguments = AbilityDelegatorRegistry.getArguments();
        abilityDelegatorArguments.bundleName = "${testTemplateParam.bundleName}";
        abilityDelegatorArguments.parameters = {
          "-b": "${testTemplateParam.bundleName}",
          "-m": "${testTemplateParam.moduleName}",
          "-s class": "${scope}",
          "-s timeout": "15000",
          "-s coverage": "${isCoverage}"
        };
        abilityDelegatorArguments.testCaseNames = "${scope}"
        console.info("[LOCAL_TEST] " + abilityDelegatorArguments);
        Hypium.hypiumTest(abilityDelegator, abilityDelegatorArguments, testsuite)
        console.info('[LOCAL_TEST] END')
      }
    
      @State
      message: string = 'Hello World'
    
      ${buildStr}
    }`;
    return pageIndexStr;
};
exports.pageIndexTemplate = pageIndexTemplate;
/**
 * 获取testAbility模板
 * @returns { string }
 */
const testAbilityTemplate = () => {
    const testAbilityStr = `
    import AbilityConstant from '@ohos.app.ability.AbilityConstant';
    import hilog from '@ohos.hilog';
    import UIAbility from '@ohos.app.ability.UIAbility';
    import Want from '@ohos.app.ability.Want';
    import window from '@ohos.window';
    
    export default class EntryAbility extends UIAbility {
        onCreate(want: Want, launchParam: AbilityConstant.LaunchParam) {
            hilog.info(0x0000, 'testTag', '%{public}s', 'Ability onCreate');
        }
    
        onDestroy() {
            hilog.info(0x0000, 'testTag', '%{public}s', 'Ability onDestroy');
        }
    
        onWindowStageCreate(windowStage: window.WindowStage) {
            // Main window is created, set main page for this ability
            hilog.info(0x0000, 'testTag', '%{public}s', 'Ability onWindowStageCreate');
    
            windowStage.loadContent('../../../.test/testability/pages/Index', (err, data) => {
                if (err.code) {
                    hilog.error(0x0000, 'testTag', 'Failed to load the content. Cause: %{public}s', JSON.stringify(err) ?? '');
                    return;
                }
                hilog.info(0x0000, 'testTag', 'Succeeded in loading the content. Data: %{public}s', JSON.stringify(data) ?? '');
            });
        }
    
        onWindowStageDestroy() {
            // Main window is destroyed, release UI related resources
            hilog.info(0x0000, 'testTag', '%{public}s', 'Ability onWindowStageDestroy');
        }
    
        onForeground() {
            // Ability has brought to foreground
            hilog.info(0x0000, 'testTag', '%{public}s', 'Ability onForeground');
        }
    
        onBackground() {
            // Ability has back to background
            hilog.info(0x0000, 'testTag', '%{public}s', 'Ability onBackground');
        }
    }
  `;
    return testAbilityStr;
};
exports.testAbilityTemplate = testAbilityTemplate;
const phoneSettingConfigTemplate = () => {
    const phoneSettingStr = `
    {
      "setting": {
        "1.0.1": {
          "Language": {
            "args": {
              "Language": "zh_CN"
            }
          }
        }
      },
      "frontend": {
        "1.0.0": {
          "Resolution": {
            "args": {
              "Resolution": "360*780"
            }
          },
          "DeviceType": {
            "args": {
              "DeviceType": "phone"
            }
          }
        }
      }
    }
  `;
    return phoneSettingStr;
};
exports.phoneSettingConfigTemplate = phoneSettingConfigTemplate;
