"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReportForHvigorw = void 0;
const etsCollect_1 = require("./etsCollect");
const report_1 = require("./report");
const fs = require("fs");
const log4js = require("log4js");
log4js.configure({
    appenders: {
        console: { type: 'console' },
    },
    categories: {
        default: { appenders: ['console'], level: 'all' },
    },
});
const consoleLogger = log4js.getLogger('console');
/**
 * 功能：生成报告对外接口
 * @param {string} projectPath 源码工程路径
 * @param {string} reportPath 报告生成路径
 * @param {string} coveragePath 覆盖率文件路径，多个文件路径之间以#拼接
 */
async function generateReportForHvigorw(projectPath, reportPath, coveragePath) {
    let valid = validParam(projectPath, reportPath, coveragePath);
    if (!valid) {
        return;
    }
    let coveragePaths = coveragePath.split('#');
    for (const item of coveragePaths) {
        if (!fs.existsSync(item)) {
            consoleLogger.error('coverageFile contains a file that does not exist.');
            return;
        }
    }
    let etsCoverageData = await (0, etsCollect_1.etsCollect)(coveragePaths, projectPath);
    let data = JSON.stringify(etsCoverageData);
    (0, report_1.report)(data, reportPath);
}
exports.generateReportForHvigorw = generateReportForHvigorw;
function validParam(projectPath, reportPath, coveragePath) {
    if (!fs.existsSync(projectPath)) {
        consoleLogger.error('projectPath does not exist');
        return false;
    }
    if (!reportPath) {
        consoleLogger.error('reportPath does not exist');
        return false;
    }
    if (!coveragePath) {
        consoleLogger.error('coverageFile does not exist');
        return false;
    }
    return true;
}
