import { AnalyzeMode } from '../util/constants.js';
import { CompileEvent } from './compile-event.js';
import { SerializedTimings } from './timer.js';
/**
 * 收集编译过程中的事件，并负责将rollup的perf转化成事件的形式
 *
 * @since 2023/6/2
 */
export declare class CompilePerf {
    private timers;
    private perf;
    constructor(perf: AnalyzeMode);
    clear(): this;
    collect(timer: SerializedTimings): void;
    transform(): Set<CompileEvent>;
    /**
     * 可能需要将事件进行持久化，视情况决定
     */
    persist(): boolean;
    private handleRollupPerf;
    /**
     * 将hook对应的事件和它的上级事件建立父子关系
     *
     * @param compileEvent hook对应的事件
     * @param parentEvent 其可能的上级事件
     * @param rootHookEvents 每个hook对应的事件作为hook内部打点的根节点
     * @private
     */
    private connectHookEvent;
    /**
     * 处理hook内部打点事件，和对应的hook根节点事件建立父子关系
     *
     * @param compileEvent 需处理的hook内部事件
     * @param rootHookEvents hook根节点事件集合
     * @private
     */
    private handleHookInteriorEvent;
    /**
     * 将插件注册的hook内部多次出现的同一打点事件合并为单个事件
     *
     * @param rootHookEvents 每个hook对应的事件
     * @private
     */
    private mergeHookInteriorEvents;
}
