export declare function findPackageJson(base: string, moduleDirs: any[]): Promise<{
    pkgJson: any;
    pkgPath: string;
    pkgJsonPath: string;
} | null>;
export declare function isUrl(str: string | URL): boolean;
export declare function isConditions(exports: any): boolean;
export declare function isMappings(exports: any): boolean;
export declare function isMixedExports(exports: any): boolean;
export declare function createBaseErrorMsg(importSpecifier: any, importer?: any): string;
export declare function createErrorMsg(context: {
    importSpecifier: any;
    importer: any;
    pkgJsonPath: any;
}, reason?: string, internal?: boolean): string;
export declare class ResolveError extends Error {
}
export declare class InvalidConfigurationError extends ResolveError {
    constructor(context: {
        importSpecifier: any;
        importer: any;
        pkgJsonPath: any;
    }, reason: any);
}
export declare class InvalidModuleSpecifierError extends ResolveError {
    constructor(context: {
        importSpecifier: any;
        importer: any;
        pkgJsonPath: any;
    }, internal?: boolean, reason?: string);
}
export declare class InvalidPackageTargetError extends ResolveError {
    constructor(context: {
        importSpecifier: any;
        importer: any;
        pkgJsonPath: any;
    }, reason: string);
}
