"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArkUIXRemoteComponentLoader = void 0;
const abstract_component_loader_1 = require("../../core/loader/abstract-component-loader");
const simple_progress_1 = require("../../core/log/simple-progress");
const arkuix_biz_util_1 = require("../util/arkuix-biz-util");
const arkuix_component_constants_1 = require("../constants/arkuix-component-constants");
const arkuix_component_dto_1 = require("./arkuix-component-dto");
const os_type_util_1 = require("../../core/util/os-type-util");
class ArkUIXRemoteComponentLoader extends abstract_component_loader_1.AbstractComponentLoader {
    constructor(sdkSettings, netClient, progress = new simple_progress_1.SimpleProgress()) {
        super(progress);
        this._sdkSettings = sdkSettings;
        this._netClient = netClient;
    }
    load() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const grsService = yield this._sdkSettings.getGrsService();
                if (!grsService) {
                    this.progress.warn('Failed to request remote ArkUI-X SDK, grsService is undefined');
                    return [];
                }
                const queryMetaUrl = (0, arkuix_biz_util_1.getQueryMetaUrl)(grsService);
                const result = yield this._netClient.doPost(queryMetaUrl, this.progress, this._createReqBody());
                const resultData = this.configComponent(result);
                const remotes = new Map();
                resultData.map(arkuixComponentDto => {
                    if (this.isValidComponent(arkuixComponentDto) && this._notDuplicate(arkuixComponentDto, remotes)) {
                        this.addToMap(remotes, arkuixComponentDto);
                    }
                    return remotes;
                });
                const sdks = [];
                remotes.forEach(value => sdks.push(value));
                return sdks;
            }
            catch (error) {
                this.progress.warn(error === null || error === void 0 ? void 0 : error.message);
            }
            return [];
        });
    }
    _createReqBody() {
        return {
            osType: this._sdkSettings.getOsType(),
            osArch: (0, os_type_util_1.getOsArch)(this.progress),
            supportVersion: arkuix_component_constants_1.ARKUIX_SUPPORT_VERSION,
        };
    }
    configComponent(jsonObjects) {
        const result = [];
        for (const jsonObject of jsonObjects) {
            const dto = new arkuix_component_dto_1.ArkUIXComponentDto();
            Object.assign(dto, jsonObject);
            this._configApiVersion(jsonObject, dto);
            dto.displayName = this.convertDisplayName(dto);
            dto.location = this.getLocation(dto, this._sdkSettings.getLocation());
            this._configArchive(jsonObject, dto);
            result.push(dto);
        }
        return result;
    }
    _configArchive(jsonObject, dto) {
        const arkUIXArchiveDto = new arkuix_component_dto_1.ArkUIXArchiveDto();
        const archive = jsonObject.archive;
        arkUIXArchiveDto.url = archive.url;
        arkUIXArchiveDto.checksum = archive.checksum;
        const size = Number(archive.size);
        if (!Number.isNaN(size)) {
            arkUIXArchiveDto.size = size;
        }
        dto.archive = arkUIXArchiveDto;
    }
    _configApiVersion(data, componentDto) {
        const apiVersion = Number(data.apiVersion);
        if (!Number.isNaN(apiVersion)) {
            componentDto.apiVersion = apiVersion;
        }
    }
    _notDuplicate(component, remotes) {
        const key = this.genKey(component);
        const previousComponent = remotes.get(key);
        if (!previousComponent) {
            return true;
        }
        return component.compareTo(previousComponent) > 0;
    }
}
exports.ArkUIXRemoteComponentLoader = ArkUIXRemoteComponentLoader;
