"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkInfoConfig = void 0;
const utils_1 = require("../util/utils");
const sdk_exception_1 = require("./sdk-exception");
const error_tip_1 = require("./error-tip");
const sdk_validator_util_1 = require("../validator/sdk-validator-util");
const validator_1 = require("../validator/validator");
/**
 * 用法示例
 * SdkInfoConfig sdkInfoConfig = SdkInfoConfig.create(sdkRoot);
 */
class SdkInfoConfig {
    constructor() {
        this._sdkRoot = '';
        /**
         * nodejs的安装目录路径
         */
        this._nodeHome = '';
        /**
         * npm config路径
         */
        this._npmConfig = '';
    }
    /**
     * 静态方法构造方法
     * @param sdkRoot
     */
    static create(sdkRoot) {
        if ((0, utils_1.isEmpty)(sdkRoot)) {
            throw new sdk_exception_1.SdkException('sdkRoot should not be empty', new error_tip_1.ErrorTip('sdkRoot should not be empty', 'sdkRoot should not be empty', ''));
        }
        const validationResult = (0, sdk_validator_util_1.validateSdkPath)(sdkRoot);
        if (validationResult.status === validator_1.Status.ERROR) {
            throw new sdk_exception_1.SdkException(validationResult.message, new error_tip_1.ErrorTip(validationResult.message, validationResult.message, ''));
        }
        const sdkInfoConfig = new SdkInfoConfig();
        sdkInfoConfig._sdkRoot = sdkRoot;
        return sdkInfoConfig;
    }
    get sdkRoot() {
        return this._sdkRoot;
    }
    get nodeHome() {
        return this._nodeHome;
    }
    setNodeHome(value) {
        this._nodeHome = value;
        return this;
    }
    get npmConfig() {
        return this._npmConfig;
    }
    setNpmConfig(value) {
        this._npmConfig = value;
        return this;
    }
    getSdkProxy() {
        if (this._sdkProxy) {
            return this._sdkProxy();
        }
        return undefined;
    }
    setSdkProxy(value) {
        this._sdkProxy = value;
        return this;
    }
}
exports.SdkInfoConfig = SdkInfoConfig;
