"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compilePattern = exports.createAxiosInstance = exports.certificates = void 0;
const url_1 = require("url");
const axios_1 = __importDefault(require("axios"));
const utils_1 = require("./utils");
const https_proxy_agent_1 = require("./https-proxy-agent");
exports.certificates = require('../../../res/cer/root.json');
const ciphers = [
    'TLS_DHE_RSA_WITH_AES_128_GCM_SHA256',
    'TLS_DHE_RSA_WITH_AES_256_GCM_SHA384',
    'TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256',
    'TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384',
    'TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256',
    'TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384',
    'TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256',
    'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256',
    ' TLS_AES_128_GCM_SHA256',
    'TLS_AES_256_GCM_SHA384',
    'TLS_CHACHA20_POLY1305_SHA256',
];
const createAxiosInstance = (_httpsProxy, _defaultOpt) => {
    const requestConfig = configDefaultRequest(_defaultOpt);
    const _axiosInstance = axios_1.default.create(requestConfig);
    if ((_httpsProxy === null || _httpsProxy === void 0 ? void 0 : _httpsProxy.proxy) || (_httpsProxy === null || _httpsProxy === void 0 ? void 0 : _httpsProxy.httpsProxy)) {
        if (_httpsProxy.proxy) {
            const proxyUrl = new url_1.URL(_httpsProxy.proxy);
            _axiosInstance.defaults.proxy = {
                protocol: proxyUrl.protocol,
                host: proxyUrl.hostname,
                port: parseInt(proxyUrl.port),
                auth: {
                    username: proxyUrl.username,
                    password: proxyUrl.password,
                },
            };
        }
        _axiosInstance.interceptors.request.use(config => {
            var _a, _b;
            if (!config.url) {
                return config;
            }
            const url = new url_1.URL(config.url);
            let noProxy = '';
            if (_httpsProxy.noProxy instanceof Array) {
                noProxy = _httpsProxy.noProxy.join(',');
            }
            else {
                noProxy = _httpsProxy.noProxy;
            }
            const isUriInNoProxy = uriInNoProxy(url, noProxy);
            if (isUriInNoProxy) {
                config.proxy = false;
            }
            else {
                if (((_a = config.url) === null || _a === void 0 ? void 0 : _a.indexOf('https://')) !== -1) {
                    config.httpsAgent = new https_proxy_agent_1.HttpsProxyAgent({
                        keepAlive: true,
                        proxy: (_b = ((0, utils_1.isEmpty)(_httpsProxy.httpsProxy) ? _httpsProxy.proxy : _httpsProxy.httpsProxy)) !== null && _b !== void 0 ? _b : '',
                        ca: exports.certificates,
                        minVersion: 'TLSv1.2',
                        maxVersion: 'TLSv1.3',
                        ciphers: ciphers.join(':'),
                    });
                    config.proxy = false;
                }
            }
            return config;
        });
    }
    return _axiosInstance;
};
exports.createAxiosInstance = createAxiosInstance;
const configDefaultRequest = (_defaultOpt) => {
    let requestConfig = _defaultOpt;
    if (!requestConfig) {
        requestConfig = {
            timeout: 20000
        };
    }
    return requestConfig;
};
/**
 * 根据字符串生成正则表达式
 *
 * @param regex
 */
const compilePattern = (regex) => {
    let result = '^';
    regex.split('').forEach(char => {
        if (/[^0-9a-zA-Z*]/.test(char)) {
            result = `${result}\\${char}`;
        }
        else if (/[*]/.test(char)) {
            result = `${result}.${char}`;
        }
        else {
            result = `${result}${char}`;
        }
    });
    return `${result}$`;
};
exports.compilePattern = compilePattern;
/*
 * formatHostname，parseNoProxy，uriInNoProxy为处理代理例外的方法，目前用的是npm配置的代理，所有跟npm的处理保持一致
 */
const formatHostname = (hostname) => {
    // 格式化hostname, 让'wei.com' 不匹配 'huawei.com';  'wei.com' => '.wei.com'
    return hostname.replace(/^\.*/, '.').toLowerCase();
};
const parseNoProxy = (noProxy) => {
    noProxy = noProxy.trim().toLowerCase();
    const noProxyParts = noProxy.split(':', 2);
    const noProxyHost = formatHostname(noProxyParts[0]);
    const noProxyPort = noProxyParts[1];
    const hasPort = noProxy.indexOf(':') > -1;
    return { hostname: noProxyHost, port: noProxyPort, hasPort: hasPort };
};
const uriInNoProxy = (uri, noProxy) => {
    if (!noProxy || noProxy === '*') {
        return false;
    }
    const port = uri.port || (uri.protocol === 'https:' ? '443' : '80');
    const hostname = formatHostname(uri.hostname);
    const noProxyList = noProxy.split(',');
    return noProxyList.map(parseNoProxy).some(noProxy => {
        const isMatchedAt = hostname.indexOf(noProxy.hostname);
        const isMatched = isMatchedAt > -1 && isMatchedAt === hostname.length - noProxy.hostname.length;
        if (noProxy.hasPort) {
            return port === noProxy.port && isMatched;
        }
        return isMatched;
    });
};
