import { SdkValidation, Validator } from './validator';
/**
 * 校验sdk路径合法性
 * @param sdkPath
 */
export declare function validateSdkPath(sdkPath: string): SdkValidation;
/**
 * 校验路径是否包含中文
 */
export declare class AsciiCharacterValidator implements Validator {
    validator(sdkPath: string): SdkValidation;
    containsNonAscii(string: string): boolean;
}
/**
 * 校验非法字符，只能是字母、数字、空格以及-_.
 */
export declare class IllegalCharacterValidator implements Validator {
    static LEGAL_FILE_NAME: RegExp;
    validator(sdkPath: string): SdkValidation;
}
/**
 * 校验文件路径分隔符
 */
export declare class InvalidSlashesValidator implements Validator {
    validator(sdkPath: string): SdkValidation;
}
/**
 * 校验路径长度
 */
export declare class PathLengthValidator implements Validator {
    static readonly WINDOWS_PATH_LENGTH_MAX: number;
    validator(sdkPath: string): SdkValidation;
}
/**
 * 校验路径是否有写权限
 */
export declare class PathWritableValidator implements Validator {
    validator(sdkPath: string): SdkValidation;
}
/**
 * 校验sdk是否在磁盘根目录下，sdk路径不能为磁盘根目录
 */
export declare class SystemRootFileValidator implements Validator {
    validator(sdkPath: string): SdkValidation;
}
/**
 * 校验sdk路径是否为空
 */
export declare class EmptyLocationValidator implements Validator {
    validator(sdkPath: string): SdkValidation;
}
