"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOhInstallTask = void 0;
const oh_install_task_1 = require("./oh-install-task");
const oh_single_task_wrapper_1 = require("./oh-single-task-wrapper");
/**
 * 创建安装任务
 * @param component Component
 * @param settings SdkSettings
 * @param netClient CommonNetClient
 */
function createOhInstallTask(component, settings, netClient) {
    return new oh_single_task_wrapper_1.OhSingleTaskWrapper(createInstallTaskHelper(component, settings, netClient));
}
exports.createOhInstallTask = createOhInstallTask;
function createInstallTaskHelper(component, sdkSettings, netClient) {
    return new oh_install_task_1.OhInstallTask(component, sdkSettings, netClient);
}
