/**
 * har依赖的接口类
 *
 * @since 2022/5/7
 */
export interface Dependency {
    /**
     * 获取package.json的路径
     *
     * @returns {string}
     * @deprecated use getPackageFilePath().
     */
    getPackageJsonPath(): string;
    /**
     * 获取类package.json、起包定义作用的文件的路径
     *
     * @returns {string}
     */
    getPackageFilePath(): string;
    /**
     * module的package.json中的name
     *
     * @returns {string}
     */
    getPackageName(): string;
    /**
     * 获取package.json中声明的依赖名,对于npm依赖来说一般跟package.json中的name一致
     *
     * @returns {string}
     */
    getDependencyName(): string;
    /**
     * 获取依赖在当前module的node_modules中的路径, 对于本地module依赖, 则对应module路径
     *
     * @returns {string}
     */
    getDependencyRootPath(): string;
    /**
     * 获取package.json中main对应文件的路径, 若没配main则默认为index.js
     * see: https://docs.npmjs.com/cli/v8/configuring-npm/package-json#main
     *
     * @returns {string}
     */
    getDependencyMainFilePath(): string;
    getDependencyTypesFilePath(): string;
    getDependencyType(): DependencyType;
    getDependencyEnum(): DependencyEnum;
    hasNative(): boolean;
}
export declare enum DependencyType {
    DEPENDENCY_TYPE_HAR = "har",
    DEPENDENCY_TYPE_HSP = "hsp"
}
export declare enum DependencyEnum {
    DEPENDENCIES = "dependencies",
    DYNAMIC_DEPENDENCIES = "dynamicDependencies"
}
