import { Dependency } from './core/dependency-interface.js';
/**
 * Module的依赖信息集合
 *
 * @since 2022/5/7
 */
export declare class ModuleDependencyInfo {
    /**
     * har module 依赖的map集合
     * key - module name
     * value -module package.json path
     *
     * @private
     */
    private readonly _moduleDependencyMap;
    private readonly _npmDependencies;
    private readonly _hasHspDependency;
    constructor(moduleDependencyMap: Map<string, Dependency>, npmDependencies: Dependency[]);
    /**
     * 依赖的本地模块与其模块名的键值对
     * @returns {Map<string, Dependency>}
     */
    getModuleDependencyMap(): Map<string, Dependency>;
    /**
     * 依赖的鸿蒙依赖，包括本地开发态的模块与发布态的远程或者本地依赖
     * @returns {Dependency[]}
     */
    getNpmDependencies(): Dependency[];
    /**
     * 判断当前模块是否有hsp依赖
     */
    hasHspDependency(): boolean;
    getHspDependencies(): Dependency[];
}
