import { FileSet } from '@ohos/hvigor';
import { TaskInputValue } from '@ohos/hvigor';
import { TargetTaskService } from './service/target-task-service.js';
import { OhosHapTask } from './task/ohos-hap-task.js';
/**
 * 收集hap和har依赖中的.so文件
 *
 * @since 2022/1/20
 */
export declare class ProcessLibs extends OhosHapTask {
    private _log;
    private readonly _moduleDir;
    private readonly localOutput;
    private readonly hapLocalLibs;
    private readonly libsOutputDir;
    private readonly _nativeOption?;
    private readonly filterRule;
    private readonly allHarLibs;
    private readonly hasLocalNativeOutput;
    private localOutputHash?;
    beforeAlwaysAction(): Promise<void>;
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    constructor(taskService: TargetTaskService);
    initTaskDepends(): void;
    protected doTaskAction(): Promise<void>;
    /**
     * 获取所有需要复制的.so文件路径
     * @returns {string[]}
     * @private
     */
    private getAllHarLibs;
    /**
     * 去除重复的so文件
     * 根据文件大小, 真实路径, md5等判断是否一致
     *
     * @param files
     * @private
     */
    private removeDuplicateFiles;
    private collectUniqueFile;
}
