"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.SignUtil=void 0;const wdk_1=require("@baize/wdk"),fs_extra_1=__importDefault(require("fs-extra")),common_const_js_1=require("../../const/common-const.js"),sign_type_enum_js_1=require("../../enum/sign-type-enum.js"),error_code_map_js_1=require("../../error/error-code-map.js"),array_util_1=require("../../utils/array-util"),keystore_utils_js_1=require("../../utils/keystore-utils.js"),ohos_logger_js_1=require("../../utils/log/ohos-logger.js"),process_utils_1=require("../../utils/process-utils"),validate_util_js_1=require("../../utils/validate/validate-util.js"),module_task_service_1=require("../service/module-task-service"),sign_command_factory_1=require("./command-builder-impl/sign-command-factory"),hvigor_1=require("@ohos/hvigor"),file_util_js_1=require("../../utils/file-util.js");class SignUtil{constructor(e,t,i,s,n){this._log=ohos_logger_js_1.OhosLogger.getLogger(SignUtil.name);const o=e.getProjectModel().getCompileApiMetaByProduct(s.name).version;this._taskService=e,this._signType=t,this._targetProduct=s,this._signCommandFactory=new sign_command_factory_1.SignCommandFactory(o),this._pathInfo=i,this._signingConfig=this.getSigningConfig(),this.sdkInfo=n}async sign(e,t){await this.executeSign(e,t),fs_extra_1.default.existsSync(e.getOutPutFilePath())||e.getSignType()!==sign_type_enum_js_1.SignTypeEnum.SHELL||fs_extra_1.default.copyFileSync(e.getInputFilePath(),e.getOutPutFilePath())}async validateBundleName(e,t,i){const s=this._taskService.getProjectModel(),n=this._taskService.isFaMode()?common_const_js_1.CommonConst.CONFIG_JSON:common_const_js_1.CommonConst.APP_CONFIG;if((null==e?void 0:e.getSignType())===sign_type_enum_js_1.SignTypeEnum.HAP||(null==e?void 0:e.getSignType())===sign_type_enum_js_1.SignTypeEnum.HOS_HAP){const e=await validate_util_js_1.ValidateUtil.getBundleNameFromP7b(this.sdkInfo,this._signingConfig,t,i),o=validate_util_js_1.ValidateUtil.getBundleNameFromHap(this._targetProduct,s);if(o!==e){const t="BundleName in the project configuration does not match that in the SigningConfigs.",i=`Open the project-level build-profile.json5 file. Change the bundleName value \n        to that in the SigningConfigs. Otherwise, go to the ${n} file and change the bundleName value there.\n        BundleName in Project: ${o}, BundleName in SigningConfigs: ${e}.`;this._log._buildError(t)._solution(i)._file(this._taskService.getProjectModel().getProfilePath())._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit()}}}async executeSign(e,t){if(!this._signingConfig)return;const i=`generate ${e.getSignType()} signing command`,s=t.createSubEvent(i,"");s.start();const n=this._signCommandFactory.createCommandBuilder(this._taskService.getProjectModel(),this._signingConfig,this.sdkInfo,e),o=n.getSignCommand(),r=`execute ${e.getSignType()} signing command`;if(this.getSigningDebugDetails(n.getSignTool(),o),(0,wdk_1.isEqual)(this._signingConfig,SignUtil.getDefaultSign())){s.stop(),s.setLog(i,hvigor_1.MetricLogType.INFO);const n=t.createSubEvent(r,"");return n.start(),await new process_utils_1.ProcessUtils(this._taskService.getNode().getName(),`Sign${e.getSignType()}`).execute(o),n.stop(),void n.setLog(r,hvigor_1.MetricLogType.INFO)}await this.validateBundleName(e,this._pathInfo,s),s.stop(),s.setLog(i,hvigor_1.MetricLogType.INFO);const g=t.createSubEvent(r,"");g.start(),this._taskService instanceof module_task_service_1.ModuleTaskService?await new process_utils_1.ProcessUtils(this._taskService.getModuleModel().getName(),`Sign${e.getSignType()}`).execute(o):await new process_utils_1.ProcessUtils(this._taskService.getProjectModel().getName(),`Sign${e.getSignType()}`).execute(o),g.stop(),g.setLog(r,hvigor_1.MetricLogType.INFO)}isSigned(e,t){const i=e.getProfileOpt().app,s=t.getTargetData().getProduct().signingConfig;if(void 0===s)return!1;const n=(0,array_util_1.getElementFromArr)(null==i?void 0:i.signingConfigs,s.substring(s.lastIndexOf(".")+1));return!!hvigor_1.startParameters.enableSignTask&&void 0!==n}getSigningConfig(){const e=this._taskService.getProjectModel().getProfileOpt().app,t=this._targetProduct.signingConfig;if(void 0===t)return this._signType===sign_type_enum_js_1.SignTypeEnum.SHELL?SignUtil.getDefaultSign():void(this._signingConfigCheckLogStr=`No signingConfig found for product ${this._targetProduct.name}`);const i=(0,array_util_1.getElementFromArr)(null==e?void 0:e.signingConfigs,t.substring(t.lastIndexOf(".")+1));return void 0===i?this._signType===sign_type_enum_js_1.SignTypeEnum.SHELL?SignUtil.getDefaultSign():void(this._signingConfigCheckLogStr=`Will skip sign '${this._signType}'. No signingConfigs profile is configured in current project.  \n               If needed, configure the signingConfigs in ${this._taskService.getProjectModel().getProfilePath()} .`):i}static getDefaultSign(){return{material:{storeFile:keystore_utils_js_1.KeyStoreHelper.getDefaultDebugKeyStoreLocation(),storePassword:keystore_utils_js_1.KeyStoreHelper.DEFAULT_STORE_PASS,keyAlias:keystore_utils_js_1.KeyStoreHelper.DEFAULT_ALIAS,keyPassword:keystore_utils_js_1.KeyStoreHelper.DEFAULT_STORE_PASS,signAlg:"",profile:"",certpath:""},name:""}}static isUseDefaultShellSign(e){const t=SignUtil.getDefaultSign().material;return e.storePassword===t.storePassword&&e.keyPassword===t.keyPassword&&e.storeFile===t.storeFile&&e.keyAlias===t.keyAlias}static getSigningConfigInputs(e,t){var i,s,n,o,r,g;const a=new Map;if(a.set(common_const_js_1.CommonConst.DISABLE_SIGN_TASK,hvigor_1.startParameters.enableSignTask),a.set("sdkToolchainsComponentVersion",e.getToolchainsComponentVersion()),!t)return a.set("existSigningConfig",!1),a;a.set("existSigningConfig",!0).set("signingConfig_name",null!==(i=t.name)&&void 0!==i?i:"").set("signingConfig_type",null!==(s=t.type)&&void 0!==s?s:"");const l=t.material;return l?(a.set("existMaterial",!0).set("signingConfig_signAlg",null!==(n=l.signAlg)&&void 0!==n?n:"").set("signingConfig_keyAlias",null!==(o=l.keyAlias)&&void 0!==o?o:"").set("signingConfig_keyPassword",null!==(r=l.keyPassword)&&void 0!==r?r:"").set("signingConfig_storePassword",null!==(g=l.storePassword)&&void 0!==g?g:""),a):(a.set("existMaterial",!1),a)}getSigningConfigInputFiles(){var e;const t=new hvigor_1.FileSet,i=null===(e=this._signingConfig)||void 0===e?void 0:e.material;return(null==i?void 0:i.certpath)&&t.addEntry(file_util_js_1.FileUtil.convertToAbsolutePath(i.certpath,this._taskService.getProjectModel().getProjectDir()),{isDirectory:!1}),(null==i?void 0:i.profile)&&t.addEntry(file_util_js_1.FileUtil.convertToAbsolutePath(i.profile,this._taskService.getProjectModel().getProjectDir()),{isDirectory:!1}),(null==i?void 0:i.storeFile)&&t.addEntry(file_util_js_1.FileUtil.convertToAbsolutePath(i.storeFile,this._taskService.getProjectModel().getProjectDir()),{isDirectory:!1}),t}getSigningDebugDetails(e,t){const i=[...t],s="******";i.splice(i.indexOf("-keyPwd")+1,1,s),i.splice(i.indexOf("-keystorePwd")+1,1,s),this._log._printDebugCommand(e,i)}}exports.SignUtil=SignUtil;