"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.CmakeArg=exports.CmakeUtil=void 0;const crypto_1=__importDefault(require("crypto")),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),common_const_js_1=require("../const/common-const.js"),code_type_enum_js_1=require("../enum/code-type-enum.js"),error_code_map_js_1=require("../error/error-code-map.js"),generate_codemodel_js_1=require("../model/cxx/generate-codemodel.js"),generate_native_library_js_1=require("../model/cxx/generate-native-library.js"),sdk_version_js_1=require("../version/sdk-version.js"),ohos_logger_js_1=require("./log/ohos-logger.js"),file_util_js_1=require("./file-util.js");class CmakeUtil{static parseLibraries(e,t,r,a){var i;const s=new generate_codemodel_js_1.GenerateCodemodel(e).getCodemodel(),o=new Map;return null===(i=null==s?void 0:s.configurations)||void 0===i||i.forEach((i=>{var s;null===(s=i.targets)||void 0===s||s.forEach((i=>{const s=new generate_native_library_js_1.GenerateNativeLibrary(a,e,r,i,t).getLibrary();i.name&&o.set(i.name,s)}))})),o}static checkNativeHeader(e,t){fs_extra_1.default.existsSync(e)||CmakeUtil._log._buildError(`The property of headerPath specifies directory ${e} which doesn't exist.`)._file(t.getProfilePath())._printErrorAndExit(t.getName()),fs_extra_1.default.statSync(e).isFile()&&CmakeUtil._log._buildError(`The property of headerPath specifies directory ${e} is not directory.`)._file(t.getProfilePath())._printErrorAndExit(t.getName())}static checkNativeCache(e,t){const r=crypto_1.default.createHash("sha256").update(e.join(" ")).digest("hex"),a=path_1.default.resolve(t,"configure_fingerprint"),i=file_util_js_1.FileUtil.readFile(a);i&&r===i||(this._log.debug("Clean the cmake cache file CMakeCache.txt due to configuration change."),this.cleanCache(t),this.updateNativeCache(a,r))}static cleanCache(e){const t=path_1.default.resolve(e,"CMakeCache.txt");file_util_js_1.FileUtil.deleteFile(t)}static updateNativeCache(e,t){try{const r=path_1.default.dirname(e);if(fs_extra_1.default.existsSync(r)){fs_extra_1.default.statSync(r).isFile()&&fs_extra_1.default.rmSync(r,{recursive:!0})}fs_extra_1.default.outputFileSync(e,t)}catch(t){this._log.error(`Please check the native cache and remove it \n        at ${e}`)}}static getCmakeListDir(e,t){if(!t)return path_1.default.resolve(e,"./src/main/cpp");let r=t.path;const a=path_1.default.resolve(e,common_const_js_1.CommonConst.PROFILE_JSON5);void 0===r&&(r="./src/main/cpp/CMakeLists.txt",this._log.warn(`The path of the cmake script in externalNativeOptions is empty. Use the default path ${r}.`)),""===r.trim()&&this._log._buildError("The configured cmake script in externalNativeOptions/path cannot be empty.")._file(a)._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit();const i=path_1.default.resolve(e,r);return fs_extra_1.default.existsSync(i)||this._log._buildError("The configured cmake script in externalNativeOptions/path does not exist.")._file(a)._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit(),"CMakeLists.txt"!==path_1.default.basename(i)&&this._log._buildError(`Error cmake script name ${path_1.default.basename(i)}, should be CMakeLists.txt`)._file(a)._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit(),path_1.default.resolve(e,r,"..")}static resolveArch(e,t,r){if(e.indexOf(this.ARCH_X86_64)>-1)return;const a=t?this.OHOS_MIN_NDK_FOR_X86_64:this.HOS_MIN_NDK_FOR_X86_64;(r.equals(a)||r.isHigherThan(a))&&e.push(this.ARCH_X86_64)}static checkAbiFilters(e){return e&&e.length>0?e:["arm64-v8a"]}static nativeTaskCondition(e,t,r){return e.getSourceSetByTargetName(t.getTargetName()).getCodeMap().has(code_type_enum_js_1.CodeType.CPP)&&void 0!==r&&t.getTargetName()!==common_const_js_1.DefaultTargetConst.OHOS_TEST_TARGET}static mergeCommandLine(e,t){const r=CmakeUtil.getArguments(t),a=CmakeUtil.parseCmakeArgs(r,void 0);return CmakeUtil.parseCmakeArgs(e,a),CmakeUtil.toCommandLine(a,e)}static toCommandLine(e,t){const r=[t[0]];return e.forEach((e=>r.push(CmakeUtil.assembleArg(e)))),r}static parseCmakeArgs(e,t){return t=t||new Map,e.forEach((e=>{const r=CmakeUtil.parseArg(e.trim());if(void 0!==r){const e=r.getPrefix()+r.getKey();t.has(e)||t.set(e,r)}})),t}static getArguments(e){return e.split(" ").filter((e=>e.startsWith("-")))}static parseArg(e){if(!e.startsWith("-"))return;const t=e.substring(0,2),r=e.substring(2),a=r.indexOf("=");if(-1===a)return new CmakeArg(t,r,void 0);{const e=r.substring(0,a).trim(),i=r.substring(a+1).trim();return new CmakeArg(t,e,i)}}static assembleArg(e){return void 0===e.getValue()?e.getPrefix()+e.getKey():`${e.getPrefix()+e.getKey()}=${e.getValue()}`}static mkCodeModelRequest(e){fs_extra_1.default.mkdirSync(path_1.default.resolve(e,".cmake","api","v1","query","codemodel-v2"),{recursive:!0}),fs_extra_1.default.mkdirSync(path_1.default.resolve(e,".cmake","api","v1","query","cmakeFiles-v1"),{recursive:!0}),fs_extra_1.default.mkdirSync(path_1.default.resolve(e,".cmake","api","v1","query","cache-v2"),{recursive:!0})}}exports.CmakeUtil=CmakeUtil,CmakeUtil._log=ohos_logger_js_1.OhosLogger.getLogger("Cmake"),CmakeUtil._nativeCacheDir=path_1.default.resolve(process.cwd(),".hvigor","cache"),CmakeUtil.ARCH_X86_64="x86_64",CmakeUtil.OHOS_MIN_NDK_FOR_X86_64=new sdk_version_js_1.SdkVersion("3.2.10.6"),CmakeUtil.HOS_MIN_NDK_FOR_X86_64=new sdk_version_js_1.SdkVersion("3.2.2.6");class CmakeArg{constructor(e,t,r){this._prefix=e,this._key=t,this._value=r}getPrefix(){return this._prefix}setPrefix(e){this._prefix=e}getKey(){return this._key}setKey(e){this._key=e}getValue(){return this._value}setValue(e){this._value=e}}exports.CmakeArg=CmakeArg;