"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.FileUtil=void 0;const hvigor_1=require("@ohos/hvigor"),crypto_1=require("crypto"),fs_1=__importDefault(require("fs")),fs_extra_1=__importDefault(require("fs-extra")),node_fs_1=require("node:fs"),os_1=__importDefault(require("os")),path_1=__importDefault(require("path")),stream_1=require("stream"),error_code_map_js_1=require("../error/error-code-map.js"),ohos_logger_js_1=require("./log/ohos-logger.js");class FileUtil{static isDirectory(...e){return fs_extra_1.default.statSync(path_1.default.resolve(...e)).isDirectory()}static checkDirWithoutDelete(...e){const t=path_1.default.resolve(...e);fs_extra_1.default.existsSync(t)||fs_extra_1.default.mkdirSync(t,{recursive:!0})}static checkFile(...e){const t=path_1.default.resolve(...e);fs_extra_1.default.existsSync(t)||FileUtil.makeFile(t),fs_extra_1.default.removeSync(t),FileUtil.makeFile(t)}static makeFile(e,t=""){fs_extra_1.default.writeFileSync(e,t)}static deleteFile(e){try{fs_extra_1.default.existsSync(e)&&fs_extra_1.default.removeSync(e)}catch(t){this._log._buildError("Delete file failed, please check and delete file.")._file(e)._errorCode(error_code_map_js_1.ECM.DECE.COMMON_UTILS)._printErrorAndExit()}}static readFile(e){try{if(!fs_extra_1.default.existsSync(e))return;return fs_extra_1.default.readFileSync(e,{encoding:"utf-8"})}catch(t){return void this._log.error(`Please check file at ${e}.`)}}static checkPathLength(e){const t=(0,hvigor_1.maxPathLength)(),r=`\t\t1. Make your project root path shorter.${os_1.default.EOL}`,s=`\t\t2. Simplify your project name.${os_1.default.EOL}`,a=`\t\t3. Simplify your module name.${os_1.default.EOL}`,i=`\t\t4. Configure a shorter target name.${os_1.default.EOL}`;e.length>t&&this._log._buildError(`The length of path exceeds the maximum length: ${t}.`)._solution(`Please try the following solutions:${os_1.default.EOL}${r}${s}${a}${i}`)._file(`'${e}'`)._errorCode(error_code_map_js_1.ECM.DECE.COMMON_UTILS)._printErrorAndExit()}static async hashEntry(e,t){const r=new Map,s=[];return this.readDir(s,e,r,t),await Promise.all(s),r}static readDir(e,t,r,s){const a=fs_extra_1.default.readdirSync(t,{withFileTypes:!0});for(const i of a){const a=path_1.default.resolve(t,i.name);if(!s||s.test(a))if(i.isDirectory())this.readDir(e,a,r,s);else{const t=this.pipelineAsync(r,a);e.push(t)}}}static async pipelineAsync(e,t){return new Promise((r=>{const s=(0,crypto_1.createHash)("md5"),a=(0,node_fs_1.createReadStream)(t);(0,stream_1.pipeline)(a,s,(()=>{e.set(t,s.digest("hex")),r()}))}))}static convertToAbsolutePath(e,t){return path_1.default.isAbsolute(e)?e:path_1.default.resolve(t,e)}static convertToAbsolutePaths(e,t){return e.map((e=>FileUtil.convertToAbsolutePath(e,t)))}static isSubDir(e,t){const r=path_1.default.relative(e,t);return r&&!r.startsWith("..")&&!path_1.default.isAbsolute(r)}static fileExists(e){return fs_1.default.existsSync(e)&&fs_1.default.realpathSync.native(e)===e}static copySpecialFileToTempDir(e,t){fs_extra_1.default.readdirSync(e).forEach((r=>{if(this.checkSpecialFile(r)){const s=path_1.default.resolve(e,r);fs_extra_1.default.statSync(s).isFile()&&fs_extra_1.default.copySync(s,path_1.default.resolve(t,r))}}))}static checkSpecialFile(e){const t=["changelog.md","CHANGELOG.md","readme.md","README.md","readme.OpenSource","README.OpenSource","license","LICENSE"],r=e.split(".")[0];return-1!==t.indexOf(e)||-1!==t.indexOf(r)}static uniqueFileName(e,t){const r=new Map;if(e.forEach((e=>{r.set(e,1)})),r.has(t)){let e=r.get(t);for(;r.has(this.addSuffix(t,e));)e++;r.set(t,e+1);const s=this.addSuffix(t,e);return r.set(s,1),s}return r.set(t,1),t}static addSuffix(e,t){return`${e}${t}`}static traverseFileFolder(e){const t=[];if(!fs_extra_1.default.statSync(e).isDirectory()||!fs_extra_1.default.existsSync(e))return[];return fs_extra_1.default.readdirSync(e).forEach((r=>{const s=path_1.default.join(e,r),a=fs_extra_1.default.statSync(s);a.isDirectory()?this.traverseFileFolder(s):a.isFile()&&t.push(r.split(".")[0])})),t}static getAllFilesFromFolder(e){const t=[];if(!fs_extra_1.default.existsSync(e)||!fs_extra_1.default.statSync(e).isDirectory())return[];return fs_extra_1.default.readdirSync(e).forEach((r=>{const s=path_1.default.join(e,r),a=fs_extra_1.default.statSync(s);a.isDirectory()?this.getAllFilesFromFolder(s):a.isFile()&&t.push(s)})),t}static getFileSuffix(e){const t=path_1.default.parse(e).base;return""===t||-1===t.indexOf(".")?t:t.substring(t.lastIndexOf(".")+1)}static normalizePathSeparator(e){return e.replace(/\\\\/g,"/").replace(/\\/g,"/").replace(/\/:/g,":")}}exports.FileUtil=FileUtil,FileUtil._log=ohos_logger_js_1.OhosLogger.getLogger("File");