"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.LibsFileCacheUtil=void 0;const crypto_1=require("crypto"),fs_extra_1=__importDefault(require("fs-extra")),node_fs_1=require("node:fs"),path_1=__importDefault(require("path")),stream_1=require("stream"),util_1=require("util"),so_strip_util_js_1=require("./so-strip-util.js");class LibsFileCacheUtil{static async getFileHash(e){if(!fs_extra_1.default.existsSync(e))return"";const t=(0,crypto_1.createHash)("md5"),i=(0,util_1.promisify)(stream_1.pipeline);return await i((0,node_fs_1.createReadStream)(e),t),t.digest("hex")}static async isChangedSource(e,t,i,a){if(void 0===t)return!0;const s=path_1.default.relative(i,e);let r;const l=t.debugSymbol;if(void 0===l)r=!1;else{const e=l.strip,t=l.exclude;if(e){r=so_strip_util_js_1.SoStripUtil.filesExcluding(t,i).some((e=>path_1.default.normalize(e)===path_1.default.normalize(s)))}else{r=so_strip_util_js_1.SoStripUtil.matchedFiles(t,i).some((e=>path_1.default.normalize(e)===path_1.default.normalize(s)))}}let o;if(void 0===a)o=!1;else if(a.strip){o=so_strip_util_js_1.SoStripUtil.filesExcluding(a.exclude,i).some((e=>path_1.default.normalize(e)===path_1.default.normalize(s)))}else{o=so_strip_util_js_1.SoStripUtil.matchedFiles(a.exclude,i).some((e=>path_1.default.normalize(e)===path_1.default.normalize(s)))}if(o!==r)return!0;const _=t.libs[e];return void 0===_||_!==await LibsFileCacheUtil.getFileHash(e)}static async isChangedDestination(e,t){const i=t.stripped[e];return void 0===i||i!==await LibsFileCacheUtil.getFileHash(e)}static async generateFileHashesForDirectory(e){if(!e||!path_1.default.isAbsolute(e))throw new Error(`Invalid ${e} path. It must be a non-empty absolute path.`);const t={};if(!fs_extra_1.default.existsSync(e))return t;return await async function e(i){const a=fs_extra_1.default.readdirSync(i);for(const s of a)try{const a=path_1.default.join(i,s),r=fs_extra_1.default.statSync(a);r.isDirectory()?await e(a):r.isFile()&&(t[a]=await LibsFileCacheUtil.getFileHash(a))}catch(e){if(!(e instanceof Error&&"code"in e&&"ENOENT"===e.code))throw e}}(e),t}static async refreshLibsFileCache(e,t,i,a){const s={libs:fs_extra_1.default.existsSync(e)?await LibsFileCacheUtil.generateFileHashesForDirectory(e):{},stripped:fs_extra_1.default.existsSync(t)?await LibsFileCacheUtil.generateFileHashesForDirectory(t):{},debugSymbol:a};return fs_extra_1.default.ensureDirSync(path_1.default.dirname(i)),await fs_extra_1.default.writeFile(i,JSON.stringify(s),"utf8"),s}}exports.LibsFileCacheUtil=LibsFileCacheUtil;