"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.LibraryResolver=exports.ArchResolver=exports.PackageResolver=void 0;const fs_extra_1=__importDefault(require("fs-extra")),os_1=__importDefault(require("os")),path_1=__importDefault(require("path")),common_const_js_1=require("../const/common-const.js"),cpu_abi_enum_js_1=require("../enum/cpu-abi-enum.js"),ohos_logger_js_1=require("./log/ohos-logger.js"),cmake_util_js_1=require("./cmake-util.js"),log=ohos_logger_js_1.OhosLogger.getLogger("ConfigureCmake");class PackageResolver{constructor(e,t,a,s){this.archs=[],this.canonicalName=e.getPackageName(),this.name=this.canonicalName.replace(common_const_js_1.NativeConst.PACKAGE_NAME_REGEX,""),this.abiList=t,this.path=e.getDependencyRootPath(),this.cmakeDir=a,this.service=s,this.headerPath=this.getHeaderPath(e,s),this.libsPath=s?s.getTargetData().getPathInfo().getIntermediatesStrippedLibsDir():path_1.default.resolve(e.getDependencyRootPath(),"libs"),this.isHeaderAvailable=fs_extra_1.default.existsSync(this.headerPath)&&fs_extra_1.default.readdirSync(this.headerPath).length>0,this.archs=this.abiList.map((e=>ArchResolver.getInstance(e,this)))}static getInstance(e,t,a,s){return new PackageResolver(e,t,a,s)}async build(){await Promise.all(this.archs.map((e=>e.build())))}getHeaderPath(e,t){var a;const s=null===(a=null==t?void 0:t.getBuildOption().nativeLib)||void 0===a?void 0:a.headerPath;return s?path_1.default.isAbsolute(s)?s:path_1.default.resolve(e.getDependencyRootPath(),s):path_1.default.resolve(e.getDependencyRootPath(),common_const_js_1.NativeConst.INCLUDE_DIR)}}exports.PackageResolver=PackageResolver;class ArchResolver{constructor(e,t){this.libraries=[],this.cmakeText="",this.arch=e,this.pkg=t,this.path=path_1.default.resolve(this.pkg.libsPath,e),this.cmakeFile=path_1.default.resolve(t.cmakeDir,e,"lib",cpu_abi_enum_js_1.CpuAbiEnum.getCpuType(e),"cmake",t.name,`${t.name}Config.cmake`)}static getInstance(e,t){return new ArchResolver(e,t)}async build(){return this.libraries=await this.calLibraries(),this.cmakeText=this.libraries.map((e=>e.text)).join(os_1.default.EOL),await fs_extra_1.default.ensureDir(path_1.default.dirname(this.cmakeFile)),await fs_extra_1.default.writeFile(this.cmakeFile,this.cmakeText),this}async calLibraries(){if(!this.pkg.service){if(fs_extra_1.default.existsSync(this.path)){log.debug(`Reading libs dir ${this.path}`);return(await this.readDir(this.path)).filter((e=>path_1.default.basename(e)!==common_const_js_1.NativeConst.SHARED_STL_LIBRARY)).map((e=>LibraryResolver.getInstance(path_1.default.basename(e),e,this)))}return log.debug("No available libraries."),[]}const e=this.pkg.service.getTargetData(),t=e.getPathInfo().getNinjaWorkDir();log.debug(`Local module ${this.pkg.name}, reading cmake code model in ${path_1.default.resolve(t,this.arch)}.`);const a=this.pkg.service.getSdkInfo().getCmakeTool(),s=[...cmake_util_js_1.CmakeUtil.parseLibraries(path_1.default.resolve(t,this.arch),e.getTargetName(),this.arch,a).values()],r=s.flatMap((e=>{var t;return null!==(t=e.getOutputs())&&void 0!==t?t:[]}));return this.pkg.service.getModuleService().getModuleModel().isHspModule()&&r.push(...s.flatMap((e=>{var t;return null!==(t=e.getRuntimeFiles())&&void 0!==t?t:[]}))),r.map((e=>path_1.default.isAbsolute(e)?e:path_1.default.resolve(t,this.arch,e))).map((e=>LibraryResolver.getInstance(path_1.default.basename(e),path_1.default.resolve(e),this)))}async readDir(e){const t=[],a=await fs_extra_1.default.readdir(e,{withFileTypes:!0});for(const s of a)s.isFile()?t.push(path_1.default.resolve(e,s.name)):t.push(...await this.readDir(path_1.default.resolve(e,s.name)));return t}}exports.ArchResolver=ArchResolver;class LibraryResolver{constructor(e,t,a){this.arch=a,this.nameOnDisk=e,this.name=this.tryGetLibraryName(),this.path=t,this.text=this.genPkgText()}static getInstance(e,t,a){return new LibraryResolver(e,t,a)}genPkgText(){const e=`${this.arch.pkg.name}::${this.name}`;let t=`if(NOT TARGET ${e})`,a="SHARED";const s=path_1.default.extname(this.nameOnDisk);switch(s){case".a":a="STATIC";break;case".so":a="SHARED";break;default:throw new Error(`Unknown library extension type ${s} from ${this.path}`)}return t+=`${os_1.default.EOL}    add_library(${e} ${a} IMPORTED)`,t+=`${os_1.default.EOL}    set_target_properties(${e} PROPERTIES`,this.arch.pkg.isHeaderAvailable&&(t+=`${os_1.default.EOL}        INTERFACE_INCLUDE_DIRECTORIES "${this.arch.pkg.headerPath.replace(/\\/g,"/")}"`),t+=`${os_1.default.EOL}        IMPORTED_LOCATION "${this.path.replace(/\\/g,"/")}"`,t+=`)${os_1.default.EOL}endif()${os_1.default.EOL}`,t}tryGetLibraryName(){const e=this.nameOnDisk.lastIndexOf(".so")>-1?this.nameOnDisk.lastIndexOf(".so"):this.nameOnDisk.lastIndexOf(".a"),t=this.nameOnDisk.toLowerCase().startsWith("lib")?3:0;return e>-1?this.nameOnDisk.substring(t,e):this.nameOnDisk.substring(t)}}exports.LibraryResolver=LibraryResolver;