import { DurationEvent } from '@ohos/hvigor';
/**
 * 对某个package.json文件检查其是否具有本地依赖
 * @param {string} packagePath 包路径
 * @param option 定制检查的配置
 *  - allowInside允许跳过在本目录内的本地依赖
 * @returns {boolean}
 */
export declare function checkHasLocalFileDependency(packagePath: string, option?: {
    allowInside?: boolean;
}): boolean;
/**
 * 对某个包收集在包内的所有本地依赖
 * @param {string} packagePath 包路径
 * @returns {string[]}
 */
export declare function collectLocalFileDependency(packagePath: string): string[];
/**
 * 判断某条路径是否为本地依赖
 * @param {string | undefined} spec
 * @returns {boolean}
 */
export declare function isLocalDependency(spec: string | undefined): boolean;
/**
 * 返回npm路径
 * @returns {string}
 */
export declare function getNpmPath(): string;
/**
 * 使用tar算法对sourceDir打包, 打包产物保存在destHarPath
 *
 * @param sourceDir 待打包路径
 * @param destHarPath 打包产物路径
 * @param durationEvent 持续事件
 */
export declare function execOhpmPack(sourceDir: string, destHarPath: string, durationEvent: DurationEvent): Promise<void>;
