"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.equalByTag = void 0;
var eq_1 = __importDefault(require("../eq"));
var equalArrays_1 = require("./equalArrays");
var COMPARE_PARTIAL_FLAG = 1;
var COMPARE_UNORDERED_FLAG = 2;
var boolTag = '[object Boolean]';
var dateTag = '[object Date]';
var errorTag = '[object Error]';
var mapTag = '[object Map]';
var numberTag = '[object Number]';
var regexpTag = '[object RegExp]';
var setTag = '[object Set]';
var stringTag = '[object String]';
var symbolTag = '[object Symbol]';
var arrayBufferTag = '[object ArrayBuffer]';
var dataViewTag = '[object DataView]';
var symbolProto = Symbol ? Symbol.prototype : undefined;
var symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;
function dealArrayBuffer(object, other, equalFunc) {
    return !((object.byteLength !== other.byteLength)
        || !equalFunc(new Uint8Array(object), new Uint8Array(other)));
}
function dealError(object, other) {
    return object.name === other.name && object.message === other.message;
}
function preEqualByTab(objectParam, otherParam, tag, bitmaskParam, customizer, equalFunc, stack) {
    var object = objectParam;
    var other = otherParam;
    var bitmask = bitmaskParam;
    var convert = function (arg) {
        return arg;
    };
    if (tag === mapTag) {
        convert = mapToArray;
        return dealSetTag(bitmask, convert, object, other, stack, customizer, equalFunc);
    }
    if (tag === setTag) {
        return dealSetTag(bitmask, convert, object, other, stack, customizer, equalFunc);
    }
    if (tag === arrayBufferTag) {
        return dealArrayBuffer(object, other, equalFunc);
    }
    if (tag === dataViewTag) {
        if ((object.byteLength !== other.byteLength)
            || (object.byteOffset !== other.byteOffset)) {
            return false;
        }
        object = object.buffer;
        other = other.buffer;
        return dealArrayBuffer(object, other, equalFunc);
    }
    return undefined;
}
function equalByTag(objectParam, otherParam, tag, bitmaskParam, customizer, equalFunc, stack) {
    var object = objectParam;
    var other = otherParam;
    var ret = preEqualByTab(objectParam, otherParam, tag, bitmaskParam, customizer, equalFunc, stack);
    if (ret !== undefined) {
        return ret;
    }
    switch (tag) {
        case boolTag:
        case dateTag:
        case numberTag:
            return (0, eq_1.default)(+object, +other);
        case errorTag:
            return dealError(object, other);
        case regexpTag:
        case stringTag:
            return object === ("".concat(other));
        case symbolTag:
            if (symbolValueOf) {
                return symbolValueOf.call(object) === symbolValueOf.call(other);
            }
            break;
        default:
            break;
    }
    return false;
}
exports.equalByTag = equalByTag;
function dealSetTag(bitmaskParam, convertParam, object, other, stack, customizer, equalFunc) {
    var convert = convertParam;
    var bitmask = bitmaskParam;
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
    if (!convert) {
        convert = setToArray;
    }
    if (object.size !== other.size && !isPartial) {
        return false;
    }
    var stacked = stack.get(object);
    if (stacked) {
        return stacked === other;
    }
    bitmask |= COMPARE_UNORDERED_FLAG;
    stack.set(object, other);
    var result = (0, equalArrays_1.equalArrays)(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
    stack.delete(object);
    return result;
}
function mapToArray(map) {
    var index = -1;
    var result = Array(map.size);
    map.forEach(function (value, key) {
        result[++index] = [key, value];
    });
    return result;
}
function setToArray(set) {
    var index = -1;
    var result = Array(set.size);
    set.forEach(function (value) {
        result[++index] = value;
    });
    return result;
}
