"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDeepProperties = void 0;
var toKey_1 = require("./toKey");
var isArray_1 = __importDefault(require("../isArray"));
var isSymbol_1 = __importDefault(require("../isSymbol"));
// 获取path对应的值
function getDeepProperties(path) {
    return function basePropertyDeepR(obj) {
        return baseGet(obj, path);
    };
}
exports.getDeepProperties = getDeepProperties;
function baseGet(obj, path) {
    var pathInner = castPath(path, obj);
    var objectInner = obj;
    var index = 0;
    var length = pathInner.length;
    while (objectInner != null && index < length) {
        objectInner = objectInner[(0, toKey_1.toKey)(pathInner[index++])];
    }
    return (index && index === length) ? objectInner : undefined;
}
// null、undefined、Symbol 没有toString方法
function toString(value) {
    if ((0, isSymbol_1.default)(value)) {
        return value;
    }
    return "".concat(value);
}
function castPath(value, object) {
    if ((0, isArray_1.default)(value)) {
        return value;
    }
    if ((0, isSymbol_1.default)(value) || value in object) {
        return [value];
    }
    return parseStringToPathArr(toString(value));
}
var propNaem = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar = /\\(\\)?/g;
/**
 * 将字符串转成路径数组。支持a.b.c及a.b[c]形式
 *
 * @private
 * @param {string} path 要转换的路径
 */
function parseStringToPathArr(path) {
    var result = [];
    if (path[0] === '.') {
        result.push('');
    }
    path.replace(propNaem, function (match, number, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
        return match;
    });
    return result;
}
