"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var floor_1 = __importDefault(require("./floor"));
var validCheck_1 = require("./common/validCheck");
/**
 * 创建一个切片数组，去除array前面的n个元素, n默认为1
 * 返回array剩余切片
 * @param array
 */
function drop(array, n) {
    if (n === void 0) { n = 1; }
    if (!(0, validCheck_1.isArray)(array) || n >= array.length) {
        return [];
    }
    if (n < 0) {
        return array;
    }
    return array.slice((0, floor_1.default)(n), array.length);
}
exports.default = drop;
