"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
/**
 * 调用 iteratee 遍历 collection(集合) 中的每个元素，
 * iteratee 调用3个参数： (value, index|key, collection)。 如果迭代函数（iteratee）显式的返回 false ，迭代会提前退出。
 * @param collection collection (Array|Object): 一个用来迭代的集合。
 * @param iteratee [iteratee=_.identity] (Function): 每次迭代调用的函数。
 * @returns (*): 返回集合 collection。
 */
function forEach(collection, iteratee) {
    var e_1, _a, e_2, _b;
    var target = Object(collection);
    if (Array.isArray(target)) {
        //   (collection as Array<any>).forEach(iteratee); 不能使用这个 foreach  forin 遍历[ , 1,1],会自动去掉未定义
        var index = -1;
        var len = collection.length;
        while (++index < len) {
            iteratee(collection[index], index);
        }
    }
    else if ((0, isArrayLike_1.default)(target)) {
        try {
            for (var target_1 = __values(target), target_1_1 = target_1.next(); !target_1_1.done; target_1_1 = target_1.next()) {
                var item = target_1_1.value;
                iteratee(item);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (target_1_1 && !target_1_1.done && (_a = target_1.return)) _a.call(target_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    else {
        var keys = Object.keys(target);
        try {
            for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var key = keys_1_1.value;
                var item = target[key];
                iteratee(item, key);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_b = keys_1.return)) _b.call(keys_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    return collection;
}
exports.default = forEach;
