export default function isNumber(object: any): boolean;
/**
 * 判断指定的字符串是否是数字。-0 和 0 都是数字
 * @param str
 * @example
 * console.log(isNumeric('123'));
 * // ==> true
 * console.log(isNumeric('123.45'));
 * // ==> true
 * console.log(isNumeric('-123.45'));
 * // ==> true
 * console.log(isNumeric('abc'));
 * // ==> false
 */
export declare function isNumberic(str: string): boolean;
/**
 * 判断指定的字符串是否是由10进制阿拉伯数字组成的正整数。
 * -0 不是正整数，0是正整数。
 * <strong>请注意，8进制、16进制字符串将被识别成字符串，不是正整数。</strong>
 *
 * @param str 待判断的字符串
 * @example
 * console.log(isPositiveInteger('123'));
 * // ==> true
 * console.log(isPositiveInteger('0'));
 * // ==> true
 * console.log(isPositiveInteger('-0'));
 * // ==> false
 * console.log(isPositiveInteger('123.45'));
 * // ==> false
 * console.log(isPositiveInteger('-123'));
 * // ==> false
 * console.log(isPositiveInteger('abc'));
 * // ==> false
 * console.log(isPositiveInteger('0xAF'));
 * // ==> false
 */
export declare function isPositiveInteger(str: string): boolean;
