"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toString_1 = __importDefault(require("./toString"));
var words_1 = __importDefault(require("./words"));
/**
 * 将字符串转成成烤肉串命名规则字符串，例如 `hello-world`.
 * @since 1.0.0
 * @Catalog String
 * @param [str = ''] (string): 待转换的字符串
 * @returns (string): 烤肉串命名规则字符串
 * @example
 * _.kebabCase('Foo Bar');
 * // => 'foo-bar'
 *
 * _.kebabCase('fooBar');
 * // => 'foo-bar'
 *
 * _.kebabCase('__FOO_BAR__');
 * // => 'foo-bar'
 */
function kebabCase(str) {
    if (str === void 0) { str = ''; }
    if ((0, isNil_1.default)(str)) {
        return str;
    }
    var strValue = str;
    if (typeof str !== 'string') {
        strValue = (0, toString_1.default)(str);
    }
    return (0, words_1.default)(strValue.replace(/['\u2019]/g, '')).reduce(function (pv, cv, idx) {
        return pv + (idx ? '-' : '') + cv.toLowerCase();
    }, '');
}
exports.default = kebabCase;
