"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var isNaN_1 = __importDefault(require("./isNaN"));
/**
 * 计算指定数组中的最小值，并返回。
 * 如果数组为空或者为虚值，则返回 undefined.
 * @Catalog core
 * @param array {Array<any>} 待计算的数组
 * @returns any | undefined
 */
function min(array) {
    var e_1, _a;
    if (array && typeof array !== 'number' && array.length > 0) {
        var minValue = array[0];
        try {
            for (var array_1 = __values(array), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
                var c = array_1_1.value;
                if (minValue > c || (0, isNil_1.default)(minValue) || (0, isNaN_1.default)(minValue)) {
                    minValue = c;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (array_1_1 && !array_1_1.done && (_a = array_1.return)) _a.call(array_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return minValue;
    }
    return undefined;
}
exports.default = min;
