"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 如果start是负数，而end或step没有指定，那么step从-1为开始。
 * 如果end没有指定，start设置为 0。
 * 如果end小于start，会创建一个空数组，除非指定了step。
 * 注意: JavaScript 遵循 IEEE-754 标准处理无法预料的浮点数结果。
 * @param rest
 */
function parseParams(rest) {
    var start = 0;
    var end = 0;
    var step = 0;
    if (rest.length === 1) {
        end = Number.isNaN(Number(rest[0])) ? 0 : Number(rest[0]);
        step = end < 0 ? -1 : 1;
    }
    else {
        start = Number.isNaN(Number(rest[0])) ? 0 : Number(rest[0]);
        end = Number.isNaN(Number(rest[1])) ? 0 : Number(rest[1]);
        if (rest.length === 2) {
            step = end > start ? 1 : -1;
        }
        if (rest.length === 3) {
            step = Number.isNaN(Number(rest[2])) ? 0 : Number(rest[2]);
        }
    }
    return { start: start, end: end, step: step };
}
/**
 * end大于start，且step大于等于0的处理
 * @param start
 * @param end
 * @param step
 */
function endIsLargerThanStart(start, end, step) {
    var result = [];
    for (var i = start; i < end; step === 0 ? i++ : i += step) {
        result.push(step === 0 ? start : i);
    }
    return result;
}
/**
 * end小于start，且step不等于0
 * @param start
 * @param end
 * @param step
 */
function endIsSmallerThanStart(start, end, step) {
    var result = [];
    if (step === 0) {
        for (var i = start; i > end; i--) {
            result.push(start);
        }
    }
    else {
        for (var i = start; i > end; step < 0 ? i += step : i -= step) {
            result.push(i);
        }
    }
    return result;
}
/**
 * 创建一个包含从start到end，但不包含end本身范围数字的数组。
 * @param end
 * @param start
 * @param step
 */
function range() {
    var rest = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        rest[_i] = arguments[_i];
    }
    var result = [];
    var _a = parseParams(rest), start = _a.start, end = _a.end, step = _a.step;
    if (end >= start) {
        result.push.apply(result, __spreadArray([], __read(endIsLargerThanStart(start, end, step)), false));
    }
    else {
        result.push.apply(result, __spreadArray([], __read(endIsSmallerThanStart(start, end, step)), false));
    }
    return result;
}
exports.default = range;
