"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isString_1 = __importDefault(require("./isString"));
var isNumber_1 = __importStar(require("./isNumber"));
var stringToPaths_1 = __importDefault(require("./common/stringToPaths"));
var toNumber_1 = __importDefault(require("./toNumber"));
/**
 * 为给指定对象 path 上设置值。如果指定的 path 不存在，那么就创建一个；
 * 如果路径中指定了序号属性，那么会创建数组（如果对象中此属性不是数组）。
 *
 * **Note:** 该方法会修改 `object` 的值。
 *
 * @category Lang
 * @param {Object} object 待修改的对象
 * @param {Array|string} path 设置值的属性路径
 * @param {*} value 设置的值
 * @returns {Object} 返回 `object`.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.set(object, 'a[0].b.c', 4);
 * console.log(object.a[0].b.c);
 * // => 4
 *
 * _.set(object, ['x', '0', 'y', 'z'], 5);
 * console.log(object.x[0].y.z);
 * // => 5
 */
function set(object, path, value) {
    return object == null ? object : baseSet(object, path, value);
}
exports.default = set;
function baseSet(object, path, value) {
    var tmp;
    if (!Array.isArray(path)) {
        tmp = [path];
    }
    else {
        tmp = path;
    }
    var targetProperty = object;
    var count = 0;
    var maxDeep = tmp.length;
    while (count < maxDeep) {
        var propKey = tmp[count];
        if (count === maxDeep - 1) {
            assignValue(targetProperty, propKey, value);
            break;
        }
        // 下一个元素是正整数 && 指定key的对象不存在时，当前取的这个对象应该是array
        var shouldBeArray = (0, isNumber_1.isPositiveInteger)(tmp[count + 1]);
        targetProperty = getOrCreatePropertyForKey(targetProperty, propKey, shouldBeArray);
        count += 1;
    }
    return object;
}
function createPropValue(isLastElement, isArray, isNextInteger) {
    if (isLastElement) {
        return isArray ? [] : {};
    }
    return isNextInteger ? [] : {};
}
function getOrCreatePropertyForKey(object, propKey, isArray) {
    var result;
    if (hasOneKey(object, propKey)) {
        // 原始值需要被覆盖，所以在原始时，需要额外给它赋值覆盖
        if (isPrimitives(object[propKey])) {
            object[propKey] = isArray ? [] : {};
        }
        result = object[propKey];
    }
    else if ((0, isString_1.default)(propKey)) {
        var propObject = object;
        var tmpPaths = (0, stringToPaths_1.default)(propKey);
        var pathCount = tmpPaths.length;
        for (var i = 0; i < pathCount; i++) {
            var pathKey = tmpPaths[i];
            /*
             * path 被拆了之后，新的 key 可能会在对象中，所以需要重新check。
             * 如果是原始值，需要被覆盖，否则后续无法赋值
             */
            if (!hasOneKey(propObject, pathKey) || isPrimitives(propObject[pathKey])) {
                propObject[pathKey] = createPropValue(isLastIndex(i, pathCount), isArray, (0, isNumber_1.isPositiveInteger)(tmpPaths[i + 1]));
            }
            propObject = propObject[pathKey];
        }
        result = propObject;
    }
    else {
        object[propKey] = isArray ? [] : {};
        result = object[propKey];
    }
    return result;
}
function hasOneKey(object, key) {
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    return object[key] != null || hasOwnProperty.apply(object, [key]);
}
function assignValue(object, propKey, value) {
    // issue https://open.codehub.huawei.com/OpenBaize/JS/wdk/issues/15
    var hasProp = hasOneKey(object, propKey);
    if (hasProp) {
        if ((0, isNumber_1.isPositiveInteger)(propKey)) {
            object[(0, toNumber_1.default)(propKey)] = value;
        }
        else if ((0, isNumber_1.default)(propKey)) {
            // 针对 -0 做的特殊处理
            setValueDirect(object, propKey.toLocaleString(), value);
        }
        else {
            setValueDirect(object, propKey, value);
        }
    }
    else {
        // string 类型 key 比较复杂，拆分成单独的函数进行key的拆解，详情参看 stringToPaths
        var paths = (0, stringToPaths_1.default)(propKey);
        var keyCounts = paths.length;
        var assignedObject = object;
        for (var i = 0; i < keyCounts; i++) {
            var path = paths[i];
            var isLastLoop = isLastIndex(i, keyCounts);
            if (!isLastLoop) {
                var currentIsArray = (0, isNumber_1.isPositiveInteger)(path);
                var realPath = currentIsArray ? (0, toNumber_1.default)(path) : path;
                var nextValue = assignedObject[realPath];
                if (isPrimitives(nextValue)) {
                    var nextIsArray = (0, isNumber_1.isPositiveInteger)(paths[i + 1]);
                    nextValue = nextIsArray ? [] : {};
                    assignedObject[realPath] = nextValue;
                }
                assignedObject = assignedObject[realPath];
            }
            else {
                // 最后一个路径的时候，就直接赋值了。
                var currentIsArray = (0, isNumber_1.isPositiveInteger)(path);
                if (currentIsArray) {
                    setValueDirect(assignedObject, (0, toNumber_1.default)(path), value);
                }
                else {
                    setValueDirect(assignedObject, path, value);
                }
            }
        }
    }
}
function setValueDirect(object, key, value) {
    if ((Number.isNaN(object[key]) && Number.isNaN(value)) || object[key] === value) {
        return;
    }
    object[key] = value;
}
function isLastIndex(index, count) {
    return index + 1 === count;
}
/**
 * 判断指定的值是否是原始值
 * @param value 待判断的值。
 * @example
 * isPrimitives(Symbol(1))
 * // => true
 */
function isPrimitives(value) {
    var valueType = typeof value;
    return value === null || value === undefined
        || valueType === 'string' || valueType === 'number' || valueType === 'boolean'
        || valueType === 'symbol' || valueType === 'bigint';
}
