"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var isObject_1 = __importDefault(require("./isObject"));
var isString_1 = __importDefault(require("./isString"));
var floor_1 = __importDefault(require("./floor"));
var toNumber_1 = __importDefault(require("./toNumber"));
/**
 * 将类组数转为数组
 * @param input
 */
function switchToArray(input) {
    var result = [];
    if ((0, isObject_1.default)(input)) {
        Object.keys(input).forEach(function (key) {
            if (key !== 'length') {
                result.push(input[key]);
            }
        });
    }
    if ((0, isString_1.default)(input)) {
        result.push.apply(result, __spreadArray([], __read(input.split('')), false));
    }
    return result;
}
/**
 * 裁剪数组/类数组array，从 start 位置开始到end结束，但不包括 end 本身的位置
 * 返回 数组array 裁剪部分的新数组
 * @param input 要裁剪数组
 * @param start 开始位置
 * @param end   结束位置
 */
function slice(input, start, end) {
    if (!Array.isArray(input) && !(0, isArrayLike_1.default)(input)) {
        return [];
    }
    var realEnd = end > input.length ? input.length : end;
    var realInput = [];
    if (!Array.isArray(input) && (0, isArrayLike_1.default)(input)) {
        realEnd = input.length;
        realInput.push.apply(realInput, __spreadArray([], __read(switchToArray(input)), false));
    }
    else {
        realEnd = realEnd === null ? 0 : realEnd;
        realEnd = realEnd === undefined ? input.length : realEnd;
        realInput = __spreadArray([], __read(input), false);
    }
    return realInput.slice((0, floor_1.default)((0, toNumber_1.default)(start)), (0, floor_1.default)((0, toNumber_1.default)(realEnd)));
}
exports.default = slice;
