"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var toString_1 = __importDefault(require("./toString"));
/**
 * unescape时要还原的字符
 */
var htmlUnescapes = {
    '&amp;': '&',
    '&lt;': '<',
    '&gt;': '>',
    '&quot;': '"',
    '&#39;': "'",
};
/**
 * 相关 token 的正则匹配
 */
var unescapedHtmlRule = /&(?:amp|lt|gt|quot|#(0+)?39);/g;
/**
 * 还原字符串中的特殊 html 字符
 *
 * @export
 * @param {(string | null)} [input] 输入的字符串
 * @returns {string} 还原后的字符串
 */
function unescape(input) {
    return (0, toString_1.default)(input).replace(unescapedHtmlRule, function (key) {
        var _a;
        // 可能为 #00...0039
        return (_a = htmlUnescapes[key]) !== null && _a !== void 0 ? _a : "'";
    });
}
exports.default = unescape;
