/**
 * 这个方法类似_.uniq ，除了它接受一个 iteratee （迭代函数），调用每一个数组（array）的每个元素以产生唯一性计算的标准。
 * iteratee 调用时会传入一个参数：(value)。
 *
 * 对 iteratee 参数详细规则描述
 * - iteratee 为 Array ，那么将会调用 `matchesProperty` 函数创建一个函数。
 *   这个函数会查找传入对象 path 为 iteratee[0] 上，是否有 iteratee[1]值，如果有则返回true，否则返回false。
 * - iteratee 为 Object，那么将会调用 `matches` 函数创建一个函数。
 *   这个函数会检查传入对象，如果拥有与iteratee相同的属性值返回 true，否则返回 false。
 * - iteratee 为 String，那么调用 `property`函数创建一个函数。
 *   该函数会返回给定对象 path 为 iteratee 的值。
 * - iteratee 为 Number，那么会调用 `property`函数创建一个函数。
 *   该函数会返回给定对象 path 为 iteratee 的值。
 * - iteratee 为 Function， 会直接调用 iteratee 遍历 array 中的每一个对象，其值用于是否为重复值得比较。
 *
 * @param array (Array): 要检查的数组。
 * @param [iteratee=_.identity] (Array|Function|Object|string): 迭代函数，调用每个元素。
 * @returns (Array): 返回新的去重后的数组。
 * @example
 * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
 * // => [2.1, 1.2]
 *
 * // The `_.property` iteratee shorthand.
 * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
 * // => [{ 'x': 1 }, { 'x': 2 }]
 */
declare function uniqBy(array: any[], iteratee?: Function | string | number | object | any[]): any[];
export default uniqBy;
